/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import java.util.Collections;
import java.util.SequencedSet;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Blocks;

public class FuelValues {
    private final Object2IntSortedMap<Item> values;

    FuelValues(Object2IntSortedMap<Item> var0) {
        this.values = var0;
    }

    public boolean isFuel(ItemStack var0) {
        return this.values.containsKey((Object)var0.getItem());
    }

    public SequencedSet<Item> fuelItems() {
        return Collections.unmodifiableSequencedSet(this.values.keySet());
    }

    public int burnDuration(ItemStack var0) {
        if (var0.isEmpty()) {
            return 0;
        }
        return this.values.getInt((Object)var0.getItem());
    }

    public static FuelValues vanillaBurnTimes(HolderLookup.a var0, FeatureFlagSet var1) {
        return FuelValues.vanillaBurnTimes(var0, var1, 200);
    }

    public static FuelValues vanillaBurnTimes(HolderLookup.a var0, FeatureFlagSet var1, int var2) {
        return new a(var0, var1).add(Items.LAVA_BUCKET, var2 * 100).add(Blocks.COAL_BLOCK, var2 * 8 * 10).add(Items.BLAZE_ROD, var2 * 12).add(Items.COAL, var2 * 8).add(Items.CHARCOAL, var2 * 8).add(TagsItem.LOGS, var2 * 3 / 2).add(TagsItem.BAMBOO_BLOCKS, var2 * 3 / 2).add(TagsItem.PLANKS, var2 * 3 / 2).add(Blocks.BAMBOO_MOSAIC, var2 * 3 / 2).add(TagsItem.WOODEN_STAIRS, var2 * 3 / 2).add(Blocks.BAMBOO_MOSAIC_STAIRS, var2 * 3 / 2).add(TagsItem.WOODEN_SLABS, var2 * 3 / 4).add(Blocks.BAMBOO_MOSAIC_SLAB, var2 * 3 / 4).add(TagsItem.WOODEN_TRAPDOORS, var2 * 3 / 2).add(TagsItem.WOODEN_PRESSURE_PLATES, var2 * 3 / 2).add(TagsItem.WOODEN_FENCES, var2 * 3 / 2).add(TagsItem.FENCE_GATES, var2 * 3 / 2).add(Blocks.NOTE_BLOCK, var2 * 3 / 2).add(Blocks.BOOKSHELF, var2 * 3 / 2).add(Blocks.CHISELED_BOOKSHELF, var2 * 3 / 2).add(Blocks.LECTERN, var2 * 3 / 2).add(Blocks.JUKEBOX, var2 * 3 / 2).add(Blocks.CHEST, var2 * 3 / 2).add(Blocks.TRAPPED_CHEST, var2 * 3 / 2).add(Blocks.CRAFTING_TABLE, var2 * 3 / 2).add(Blocks.DAYLIGHT_DETECTOR, var2 * 3 / 2).add(TagsItem.BANNERS, var2 * 3 / 2).add(Items.BOW, var2 * 3 / 2).add(Items.FISHING_ROD, var2 * 3 / 2).add(Blocks.LADDER, var2 * 3 / 2).add(TagsItem.SIGNS, var2).add(TagsItem.HANGING_SIGNS, var2 * 4).add(Items.WOODEN_SHOVEL, var2).add(Items.WOODEN_SWORD, var2).add(Items.WOODEN_HOE, var2).add(Items.WOODEN_AXE, var2).add(Items.WOODEN_PICKAXE, var2).add(TagsItem.WOODEN_DOORS, var2).add(TagsItem.BOATS, var2 * 6).add(TagsItem.WOOL, var2 / 2).add(TagsItem.WOODEN_BUTTONS, var2 / 2).add(Items.STICK, var2 / 2).add(TagsItem.SAPLINGS, var2 / 2).add(Items.BOWL, var2 / 2).add(TagsItem.WOOL_CARPETS, 1 + var2 / 3).add(Blocks.DRIED_KELP_BLOCK, 1 + var2 * 20).add(Items.CROSSBOW, var2 * 3 / 2).add(Blocks.BAMBOO, var2 / 4).add(Blocks.DEAD_BUSH, var2 / 2).add(Blocks.SCAFFOLDING, var2 / 4).add(Blocks.LOOM, var2 * 3 / 2).add(Blocks.BARREL, var2 * 3 / 2).add(Blocks.CARTOGRAPHY_TABLE, var2 * 3 / 2).add(Blocks.FLETCHING_TABLE, var2 * 3 / 2).add(Blocks.SMITHING_TABLE, var2 * 3 / 2).add(Blocks.COMPOSTER, var2 * 3 / 2).add(Blocks.AZALEA, var2 / 2).add(Blocks.FLOWERING_AZALEA, var2 / 2).add(Blocks.MANGROVE_ROOTS, var2 * 3 / 2).remove(TagsItem.NON_FLAMMABLE_WOOD).build();
    }

    public static class a {
        private final HolderLookup<Item> items;
        private final FeatureFlagSet enabledFeatures;
        private final Object2IntSortedMap<Item> values = new Object2IntLinkedOpenHashMap();

        public a(HolderLookup.a var0, FeatureFlagSet var1) {
            this.items = var0.lookupOrThrow(Registries.ITEM);
            this.enabledFeatures = var1;
        }

        public FuelValues build() {
            return new FuelValues(this.values);
        }

        public a remove(TagKey<Item> var0) {
            this.values.keySet().removeIf(var1 -> var1.builtInRegistryHolder().is(var0));
            return this;
        }

        public a add(TagKey<Item> var0, int var12) {
            this.items.get(var0).ifPresent(var1 -> {
                for (Holder var3 : var1) {
                    this.putInternal(var12, (Item)var3.value());
                }
            });
            return this;
        }

        public a add(IMaterial var0, int var1) {
            Item var2 = var0.asItem();
            this.putInternal(var1, var2);
            return this;
        }

        private void putInternal(int var0, Item var1) {
            if (var1.isEnabled(this.enabledFeatures)) {
                this.values.put((Object)var1, var0);
            }
        }
    }
}

