/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.TargetColorParticleOption;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.creaking.CreakingTransient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class CreakingHeartBlockEntity
extends TileEntity {
    private static final int PLAYER_DETECTION_RANGE = 32;
    public static final int CREAKING_ROAMING_RADIUS = 32;
    private static final int DISTANCE_CREAKING_TOO_FAR = 34;
    private static final int SPAWN_RANGE_XZ = 16;
    private static final int SPAWN_RANGE_Y = 8;
    private static final int ATTEMPTS_PER_SPAWN = 5;
    private static final int UPDATE_TICKS = 20;
    private static final int HURT_CALL_TOTAL_TICKS = 100;
    private static final int NUMBER_OF_HURT_CALLS = 10;
    private static final int HURT_CALL_INTERVAL = 10;
    private static final int HURT_CALL_PARTICLE_TICKS = 50;
    @Nullable
    private CreakingTransient creaking;
    private int ticker;
    private int emitter;
    @Nullable
    private Vec3D emitterTarget;
    private int outputSignal;

    public CreakingHeartBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.CREAKING_HEART, var0, var1);
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, CreakingHeartBlockEntity var3) {
        Object var5;
        int var4 = var3.computeAnalogOutputSignal();
        if (var3.outputSignal != var4) {
            var3.outputSignal = var4;
            var0.updateNeighbourForOutputSignal(var1, Blocks.CREAKING_HEART);
        }
        if (var3.emitter > 0) {
            if (var3.emitter > 50) {
                var3.emitParticles((WorldServer)var0, 1, true);
                var3.emitParticles((WorldServer)var0, 1, false);
            }
            if (var3.emitter % 10 == 0 && var0 instanceof WorldServer) {
                var5 = (WorldServer)var0;
                if (var3.emitterTarget != null) {
                    if (var3.creaking != null) {
                        var3.emitterTarget = var3.creaking.getBoundingBox().getCenter();
                    }
                    Vec3D var6 = Vec3D.atCenterOf(var1);
                    float var7 = 0.2f + 0.8f * (float)(100 - var3.emitter) / 100.0f;
                    Vec3D var8 = var6.subtract(var3.emitterTarget).scale(var7).add(var3.emitterTarget);
                    BlockPosition var9 = BlockPosition.containing(var8);
                    float var10 = (float)var3.emitter / 2.0f / 100.0f + 0.5f;
                    ((World)var5).playSound(null, var9, SoundEffects.CREAKING_HEART_HURT, SoundCategory.BLOCKS, var10, 1.0f);
                }
            }
            --var3.emitter;
        }
        if (var3.ticker-- >= 0) {
            return;
        }
        var3.ticker = 20;
        if (var3.creaking != null) {
            if (!CreakingHeartBlock.canSummonCreaking(var0) || var3.distanceToCreaking() > 34.0) {
                var3.removeProtector(null);
                return;
            }
            if (var3.creaking.isRemoved()) {
                var3.creaking = null;
            }
            if (!CreakingHeartBlock.hasRequiredLogs(var2, var0, var1) && var3.creaking == null) {
                var0.setBlock(var1, (IBlockData)var2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.a.DISABLED), 3);
            }
            return;
        }
        if (!CreakingHeartBlock.hasRequiredLogs(var2, var0, var1)) {
            var0.setBlock(var1, (IBlockData)var2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.a.DISABLED), 3);
            return;
        }
        if (!CreakingHeartBlock.canSummonCreaking(var0)) {
            if (var2.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.a.ACTIVE) {
                var0.setBlock(var1, (IBlockData)var2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.a.DORMANT), 3);
                return;
            }
        } else if (var2.getValue(CreakingHeartBlock.CREAKING) == CreakingHeartBlock.a.DORMANT) {
            var0.setBlock(var1, (IBlockData)var2.setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.a.ACTIVE), 3);
            return;
        }
        if (var2.getValue(CreakingHeartBlock.CREAKING) != CreakingHeartBlock.a.ACTIVE) {
            return;
        }
        if (var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return;
        }
        if (var0 instanceof WorldServer && !((WorldServer)(var5 = (WorldServer)var0)).getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return;
        }
        var5 = var0.getNearestPlayer((double)var1.getX(), (double)var1.getY(), (double)var1.getZ(), 32.0, false);
        if (var5 != null) {
            var3.creaking = CreakingHeartBlockEntity.spawnProtector((WorldServer)var0, var3);
            if (var3.creaking != null) {
                var3.creaking.makeSound(SoundEffects.CREAKING_SPAWN);
                var0.playSound(null, var3.getBlockPos(), SoundEffects.CREAKING_HEART_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private double distanceToCreaking() {
        if (this.creaking == null) {
            return 0.0;
        }
        return Math.sqrt(this.creaking.distanceToSqr(Vec3D.atBottomCenterOf(this.getBlockPos())));
    }

    @Nullable
    private static CreakingTransient spawnProtector(WorldServer var0, CreakingHeartBlockEntity var1) {
        BlockPosition var2 = var1.getBlockPos();
        Optional<CreakingTransient> var3 = SpawnUtil.trySpawnMob(EntityTypes.CREAKING_TRANSIENT, EntitySpawnReason.SPAWNER, var0, var2, 5, 16, 8, SpawnUtil.a.ON_TOP_OF_COLLIDER_NO_LEAVES);
        if (var3.isEmpty()) {
            return null;
        }
        CreakingTransient var4 = var3.get();
        var0.gameEvent((Entity)var4, GameEvent.ENTITY_PLACE, var4.position());
        var0.broadcastEntityEvent(var4, (byte)60);
        var4.bindToCreakingHeart(var2);
        return var4;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public void creakingHurt() {
        if (this.creaking == null) {
            return;
        }
        World world = this.level;
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer var0 = (WorldServer)world;
        this.emitParticles(var0, 20, false);
        this.emitter = 100;
        this.emitterTarget = this.creaking.getBoundingBox().getCenter();
    }

    private void emitParticles(WorldServer var0, int var1, boolean var2) {
        if (this.creaking == null) {
            return;
        }
        int var3 = var2 ? 16545810 : 0x5F5F5F;
        RandomSource var4 = var0.random;
        for (double var5 = 0.0; var5 < (double)var1; var5 += 1.0) {
            Object var9;
            Vec3D var7 = this.creaking.getBoundingBox().getMinPosition().add(var4.nextDouble() * this.creaking.getBoundingBox().getXsize(), var4.nextDouble() * this.creaking.getBoundingBox().getYsize(), var4.nextDouble() * this.creaking.getBoundingBox().getZsize());
            Vec3D var8 = Vec3D.atLowerCornerOf(this.getBlockPos()).add(var4.nextDouble(), var4.nextDouble(), var4.nextDouble());
            if (var2) {
                var9 = var7;
                var7 = var8;
                var8 = var9;
            }
            var9 = new TargetColorParticleOption(var8, var3);
            var0.sendParticles(var9, var7.x, var7.y, var7.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void removeProtector(@Nullable DamageSource var0) {
        if (this.creaking != null) {
            this.creaking.tearDown(var0);
            this.creaking = null;
        }
    }

    public boolean isProtector(Creaking var0) {
        return this.creaking == var0;
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public int computeAnalogOutputSignal() {
        if (this.creaking == null) {
            return 0;
        }
        double var0 = this.distanceToCreaking();
        double var2 = Math.clamp(var0, 0.0, 32.0) / 32.0;
        return 15 - (int)Math.floor(var2 * 15.0);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

