/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.grower.WorldGenTreeProvider;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class MangrovePropaguleBlock
extends BlockSapling
implements IBlockWaterlogged {
    public static final MapCodec<MangrovePropaguleBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)WorldGenTreeProvider.CODEC.fieldOf("tree").forGetter(var0 -> var0.treeGrower), MangrovePropaguleBlock.propertiesCodec()).apply((Applicative)var02, MangrovePropaguleBlock::new));
    public static final BlockStateInteger AGE = BlockProperties.AGE_4;
    public static final int MAX_AGE = 4;
    private static final VoxelShape[] SHAPE_PER_AGE = new VoxelShape[]{Block.box(7.0, 13.0, 7.0, 9.0, 16.0, 9.0), Block.box(7.0, 10.0, 7.0, 9.0, 16.0, 9.0), Block.box(7.0, 7.0, 7.0, 9.0, 16.0, 9.0), Block.box(7.0, 3.0, 7.0, 9.0, 16.0, 9.0), Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateBoolean HANGING = BlockProperties.HANGING;

    public MapCodec<MangrovePropaguleBlock> codec() {
        return CODEC;
    }

    public MangrovePropaguleBlock(WorldGenTreeProvider var0, BlockBase.Info var1) {
        super(var0, var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(STAGE, 0)).setValue(AGE, 0)).setValue(WATERLOGGED, false)).setValue(HANGING, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(STAGE).add(AGE).add(WATERLOGGED).add(HANGING);
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return super.mayPlaceOn(var0, var1, var2) || var0.is(Blocks.CLAY);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == FluidTypes.WATER;
        return (IBlockData)((IBlockData)super.getStateForPlacement(var0).setValue(WATERLOGGED, var2)).setValue(AGE, 4);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        Vec3D var4 = var0.getOffset(var2);
        VoxelShape var5 = var0.getValue(HANGING) == false ? SHAPE_PER_AGE[4] : SHAPE_PER_AGE[var0.getValue(AGE)];
        return var5.move(var4.x, var4.y, var4.z);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        if (MangrovePropaguleBlock.isHanging(var0)) {
            return var1.getBlockState(var2.above()).is(Blocks.MANGROVE_LEAVES);
        }
        return super.canSurvive(var0, var1, var2);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (var4 == EnumDirection.UP && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!MangrovePropaguleBlock.isHanging(var0)) {
            if (var3.nextInt(7) == 0) {
                this.advanceTree(var1, var2, var0, var3);
            }
            return;
        }
        if (!MangrovePropaguleBlock.isFullyGrown(var0)) {
            var1.setBlock(var2, (IBlockData)var0.cycle(AGE), 2);
        }
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return !MangrovePropaguleBlock.isHanging(var2) || !MangrovePropaguleBlock.isFullyGrown(var2);
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return MangrovePropaguleBlock.isHanging(var3) ? !MangrovePropaguleBlock.isFullyGrown(var3) : super.isBonemealSuccess(var0, var1, var2, var3);
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        if (MangrovePropaguleBlock.isHanging(var3) && !MangrovePropaguleBlock.isFullyGrown(var3)) {
            var0.setBlock(var2, (IBlockData)var3.cycle(AGE), 2);
        } else {
            super.performBonemeal(var0, var1, var2, var3);
        }
    }

    private static boolean isHanging(IBlockData var0) {
        return var0.getValue(HANGING);
    }

    private static boolean isFullyGrown(IBlockData var0) {
        return var0.getValue(AGE) == 4;
    }

    public static IBlockData createNewHangingPropagule() {
        return MangrovePropaguleBlock.createNewHangingPropagule(0);
    }

    public static IBlockData createNewHangingPropagule(int var0) {
        return (IBlockData)((IBlockData)Blocks.MANGROVE_PROPAGULE.defaultBlockState().setValue(HANGING, true)).setValue(AGE, var0);
    }
}

