/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    public static final BlockStateBoolean BERRIES = BlockProperties.BERRIES;

    public static EnumInteractionResult use(@Nullable Entity var0, IBlockData var1, World var2, BlockPosition var3) {
        if (var1.getValue(BERRIES).booleanValue()) {
            Block.popResource(var2, var3, new ItemStack(Items.GLOW_BERRIES, 1));
            float var4 = MathHelper.randomBetween(var2.random, 0.8f, 1.2f);
            var2.playSound(null, var3, SoundEffects.CAVE_VINES_PICK_BERRIES, SoundCategory.BLOCKS, 1.0f, var4);
            IBlockData var5 = (IBlockData)var1.setValue(BERRIES, false);
            var2.setBlock(var3, var5, 2);
            var2.gameEvent(GameEvent.BLOCK_CHANGE, var3, GameEvent.a.of(var0, var5));
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    public static boolean hasGlowBerries(IBlockData var0) {
        return var0.hasProperty(BERRIES) && var0.getValue(BERRIES) != false;
    }

    public static ToIntFunction<IBlockData> emission(int var0) {
        return var1 -> var1.getValue(BlockProperties.BERRIES) != false ? var0 : 0;
    }
}

