/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class CandleCakeBlock
extends AbstractCandleBlock {
    public static final MapCodec<CandleCakeBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("candle").forGetter(var0 -> var0.candleBlock), CandleCakeBlock.propertiesCodec()).apply((Applicative)var02, CandleCakeBlock::new));
    public static final BlockStateBoolean LIT = AbstractCandleBlock.LIT;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final VoxelShape CAKE_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 8.0, 15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.box(7.0, 8.0, 7.0, 9.0, 14.0, 9.0);
    protected static final VoxelShape SHAPE = VoxelShapes.or(CAKE_SHAPE, CANDLE_SHAPE);
    private static final Map<CandleBlock, CandleCakeBlock> BY_CANDLE = Maps.newHashMap();
    private static final Iterable<Vec3D> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3D(0.5, 1.0, 0.5));
    private final CandleBlock candleBlock;

    public MapCodec<CandleCakeBlock> codec() {
        return CODEC;
    }

    protected CandleCakeBlock(Block var0, BlockBase.Info var1) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LIT, false));
        if (!(var0 instanceof CandleBlock)) {
            throw new IllegalArgumentException("Expected block to be of " + String.valueOf(CandleBlock.class) + " was " + String.valueOf(var0.getClass()));
        }
        CandleBlock var2 = (CandleBlock)var0;
        BY_CANDLE.put(var2, this);
        this.candleBlock = var2;
    }

    @Override
    protected Iterable<Vec3D> getParticleOffsets(IBlockData var0) {
        return PARTICLE_OFFSETS;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (var0.is(Items.FLINT_AND_STEEL) || var0.is(Items.FIRE_CHARGE)) {
            return EnumInteractionResult.PASS;
        }
        if (CandleCakeBlock.candleHit(var6) && var0.isEmpty() && var1.getValue(LIT).booleanValue()) {
            CandleCakeBlock.extinguish(var4, var1, var2, var3);
            return EnumInteractionResult.SUCCESS;
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        EnumInteractionResult var5 = BlockCake.eat(var1, var2, Blocks.CAKE.defaultBlockState(), var3);
        if (var5.consumesAction()) {
            CandleCakeBlock.dropResources(var0, var1, var2);
        }
        return var5;
    }

    private static boolean candleHit(MovingObjectPositionBlock var0) {
        return var0.getLocation().y - (double)var0.getBlockPos().getY() > 0.5;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LIT);
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(Blocks.CAKE);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == EnumDirection.DOWN && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.below()).isSolid();
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return BlockCake.FULL_CAKE_SIGNAL;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    public static IBlockData byCandle(CandleBlock var0) {
        return BY_CANDLE.get(var0).defaultBlockState();
    }

    public static boolean canLight(IBlockData var0) {
        return var0.is(TagsBlock.CANDLE_CAKES, var1 -> var1.hasProperty(LIT) && var0.getValue(LIT) == false);
    }
}

