/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockIce;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.redstone.Orientation;

public class BlockIceFrost
extends BlockIce {
    public static final MapCodec<BlockIceFrost> CODEC = BlockIceFrost.simpleCodec(BlockIceFrost::new);
    public static final int MAX_AGE = 3;
    public static final BlockStateInteger AGE = BlockProperties.AGE_3;
    private static final int NEIGHBORS_TO_AGE = 4;
    private static final int NEIGHBORS_TO_MELT = 2;

    public MapCodec<BlockIceFrost> codec() {
        return CODEC;
    }

    public BlockIceFrost(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        var1.scheduleTick(var2, this, MathHelper.nextInt(var1.getRandom(), 60, 120));
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if ((var3.nextInt(3) == 0 || this.fewerNeigboursThan(var1, var2, 4)) && var1.getMaxLocalRawBrightness(var2) > 11 - var0.getValue(AGE) - var0.getLightBlock() && this.slightlyMelt(var0, var1, var2)) {
            BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
            for (EnumDirection var8 : EnumDirection.values()) {
                var4.setWithOffset((BaseBlockPosition)var2, var8);
                IBlockData var9 = var1.getBlockState(var4);
                if (!var9.is(this) || this.slightlyMelt(var9, var1, var4)) continue;
                var1.scheduleTick((BlockPosition)var4, this, MathHelper.nextInt(var3, 20, 40));
            }
            return;
        }
        var1.scheduleTick(var2, this, MathHelper.nextInt(var3, 20, 40));
    }

    private boolean slightlyMelt(IBlockData var0, World var1, BlockPosition var2) {
        int var3 = var0.getValue(AGE);
        if (var3 < 3) {
            var1.setBlock(var2, (IBlockData)var0.setValue(AGE, var3 + 1), 2);
            return false;
        }
        this.melt(var0, var1, var2);
        return true;
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var3.defaultBlockState().is(this) && this.fewerNeigboursThan(var1, var2, 2)) {
            this.melt(var0, var1, var2);
        }
        super.neighborChanged(var0, var1, var2, var3, var4, var5);
    }

    private boolean fewerNeigboursThan(IBlockAccess var0, BlockPosition var1, int var2) {
        int var3 = 0;
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var8 : EnumDirection.values()) {
            var4.setWithOffset((BaseBlockPosition)var1, var8);
            if (!var0.getBlockState(var4).is(this) || ++var3 < var2) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return ItemStack.EMPTY;
    }
}

