/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3D;

public class BlockEndGateway
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEndGateway> CODEC = BlockEndGateway.simpleCodec(BlockEndGateway::new);

    public MapCodec<BlockEndGateway> codec() {
        return CODEC;
    }

    protected BlockEndGateway(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityEndGateway(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockEndGateway.createTickerHelper(var2, TileEntityTypes.END_GATEWAY, var0.isClientSide ? TileEntityEndGateway::beamAnimationTick : TileEntityEndGateway::portalTick);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        TileEntity var4 = var1.getBlockEntity(var2);
        if (!(var4 instanceof TileEntityEndGateway)) {
            return;
        }
        int var5 = ((TileEntityEndGateway)var4).getParticleAmount();
        for (int var6 = 0; var6 < var5; ++var6) {
            double var7 = (double)var2.getX() + var3.nextDouble();
            double var9 = (double)var2.getY() + var3.nextDouble();
            double var11 = (double)var2.getZ() + var3.nextDouble();
            double var13 = (var3.nextDouble() - 0.5) * 0.5;
            double var15 = (var3.nextDouble() - 0.5) * 0.5;
            double var17 = (var3.nextDouble() - 0.5) * 0.5;
            int var19 = var3.nextInt(2) * 2 - 1;
            if (var3.nextBoolean()) {
                var11 = (double)var2.getZ() + 0.5 + 0.25 * (double)var19;
                var17 = var3.nextFloat() * 2.0f * (float)var19;
            } else {
                var7 = (double)var2.getX() + 0.5 + 0.25 * (double)var19;
                var13 = var3.nextFloat() * 2.0f * (float)var19;
            }
            var1.addParticle(Particles.PORTAL, var7, var9, var11, var13, var15, var17);
        }
    }

    @Override
    public ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, FluidType var1) {
        return false;
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (var3.canUsePortal(false)) {
            TileEntityEndGateway var5;
            TileEntity var4 = var1.getBlockEntity(var2);
            if (!var1.isClientSide && var4 instanceof TileEntityEndGateway && !(var5 = (TileEntityEndGateway)var4).isCoolingDown()) {
                var3.setAsInsidePortal(this, var2);
                TileEntityEndGateway.triggerCooldown(var1, var2, var0, var5);
            }
        }
    }

    @Override
    @Nullable
    public TeleportTransition getPortalDestination(WorldServer var0, Entity var1, BlockPosition var2) {
        TileEntity var3 = var0.getBlockEntity(var2);
        if (!(var3 instanceof TileEntityEndGateway)) {
            return null;
        }
        TileEntityEndGateway var4 = (TileEntityEndGateway)var3;
        Vec3D var5 = var4.getPortalPosition(var0, var2);
        if (var5 == null) {
            return null;
        }
        if (var1 instanceof EntityEnderPearl) {
            return new TeleportTransition(var0, var5, Vec3D.ZERO, 0.0f, 0.0f, Set.of(), TeleportTransition.PLACE_PORTAL_TICKET);
        }
        return new TeleportTransition(var0, var5, Vec3D.ZERO, 0.0f, 0.0f, Relative.union(Relative.DELTA, Relative.ROTATION), TeleportTransition.PLACE_PORTAL_TICKET);
    }
}

