/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockCobbleWall
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockCobbleWall> CODEC = BlockCobbleWall.simpleCodec(BlockCobbleWall::new);
    public static final BlockStateBoolean UP = BlockProperties.UP;
    public static final BlockStateEnum<BlockPropertyWallHeight> EAST_WALL = BlockProperties.EAST_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> NORTH_WALL = BlockProperties.NORTH_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> SOUTH_WALL = BlockProperties.SOUTH_WALL;
    public static final BlockStateEnum<BlockPropertyWallHeight> WEST_WALL = BlockProperties.WEST_WALL;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private final Map<IBlockData, VoxelShape> shapeByIndex;
    private final Map<IBlockData, VoxelShape> collisionShapeByIndex;
    private static final int WALL_WIDTH = 3;
    private static final int WALL_HEIGHT = 14;
    private static final int POST_WIDTH = 4;
    private static final int POST_COVER_WIDTH = 1;
    private static final int WALL_COVER_START = 7;
    private static final int WALL_COVER_END = 9;
    private static final VoxelShape POST_TEST = Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0);
    private static final VoxelShape NORTH_TEST = Block.box(7.0, 0.0, 0.0, 9.0, 16.0, 9.0);
    private static final VoxelShape SOUTH_TEST = Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 16.0);
    private static final VoxelShape WEST_TEST = Block.box(0.0, 0.0, 7.0, 9.0, 16.0, 9.0);
    private static final VoxelShape EAST_TEST = Block.box(7.0, 0.0, 7.0, 16.0, 16.0, 9.0);

    public MapCodec<BlockCobbleWall> codec() {
        return CODEC;
    }

    public BlockCobbleWall(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(UP, true)).setValue(NORTH_WALL, BlockPropertyWallHeight.NONE)).setValue(EAST_WALL, BlockPropertyWallHeight.NONE)).setValue(SOUTH_WALL, BlockPropertyWallHeight.NONE)).setValue(WEST_WALL, BlockPropertyWallHeight.NONE)).setValue(WATERLOGGED, false));
        this.shapeByIndex = this.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape var0, BlockPropertyWallHeight var1, VoxelShape var2, VoxelShape var3) {
        if (var1 == BlockPropertyWallHeight.TALL) {
            return VoxelShapes.or(var0, var3);
        }
        if (var1 == BlockPropertyWallHeight.LOW) {
            return VoxelShapes.or(var0, var2);
        }
        return var0;
    }

    private Map<IBlockData, VoxelShape> makeShapes(float var0, float var1, float var2, float var3, float var4, float var5) {
        float var6 = 8.0f - var0;
        float var7 = 8.0f + var0;
        float var8 = 8.0f - var1;
        float var9 = 8.0f + var1;
        VoxelShape var10 = Block.box(var6, 0.0, var6, var7, var2, var7);
        VoxelShape var11 = Block.box(var8, var3, 0.0, var9, var4, var9);
        VoxelShape var12 = Block.box(var8, var3, var8, var9, var4, 16.0);
        VoxelShape var13 = Block.box(0.0, var3, var8, var9, var4, var9);
        VoxelShape var14 = Block.box(var8, var3, var8, 16.0, var4, var9);
        VoxelShape var15 = Block.box(var8, var3, 0.0, var9, var5, var9);
        VoxelShape var16 = Block.box(var8, var3, var8, var9, var5, 16.0);
        VoxelShape var17 = Block.box(0.0, var3, var8, var9, var5, var9);
        VoxelShape var18 = Block.box(var8, var3, var8, 16.0, var5, var9);
        ImmutableMap.Builder var19 = ImmutableMap.builder();
        for (Boolean var21 : UP.getPossibleValues()) {
            for (BlockPropertyWallHeight var23 : EAST_WALL.getPossibleValues()) {
                for (BlockPropertyWallHeight var25 : NORTH_WALL.getPossibleValues()) {
                    for (BlockPropertyWallHeight var27 : WEST_WALL.getPossibleValues()) {
                        for (BlockPropertyWallHeight var29 : SOUTH_WALL.getPossibleValues()) {
                            VoxelShape var30 = VoxelShapes.empty();
                            var30 = BlockCobbleWall.applyWallShape(var30, var23, var14, var18);
                            var30 = BlockCobbleWall.applyWallShape(var30, var27, var13, var17);
                            var30 = BlockCobbleWall.applyWallShape(var30, var25, var11, var15);
                            var30 = BlockCobbleWall.applyWallShape(var30, var29, var12, var16);
                            if (var21.booleanValue()) {
                                var30 = VoxelShapes.or(var30, var10);
                            }
                            IBlockData var31 = (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(UP, var21)).setValue(EAST_WALL, var23)).setValue(WEST_WALL, var27)).setValue(NORTH_WALL, var25)).setValue(SOUTH_WALL, var29);
                            var19.put((Object)((IBlockData)var31.setValue(WATERLOGGED, false)), (Object)var30);
                            var19.put((Object)((IBlockData)var31.setValue(WATERLOGGED, true)), (Object)var30);
                        }
                    }
                }
            }
        }
        return var19.build();
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapeByIndex.get(var0);
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.collisionShapeByIndex.get(var0);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    private boolean connectsTo(IBlockData var0, boolean var1, EnumDirection var2) {
        Block var3 = var0.getBlock();
        boolean var4 = var3 instanceof BlockFenceGate && BlockFenceGate.connectsToDirection(var0, var2);
        return var0.is(TagsBlock.WALLS) || !BlockCobbleWall.isExceptionForConnection(var0) && var1 || var3 instanceof BlockIronBars || var4;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        Fluid var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        BlockPosition var4 = var2.north();
        BlockPosition var5 = var2.east();
        BlockPosition var6 = var2.south();
        BlockPosition var7 = var2.west();
        BlockPosition var8 = var2.above();
        IBlockData var9 = var1.getBlockState(var4);
        IBlockData var10 = var1.getBlockState(var5);
        IBlockData var11 = var1.getBlockState(var6);
        IBlockData var12 = var1.getBlockState(var7);
        IBlockData var13 = var1.getBlockState(var8);
        boolean var14 = this.connectsTo(var9, var9.isFaceSturdy(var1, var4, EnumDirection.SOUTH), EnumDirection.SOUTH);
        boolean var15 = this.connectsTo(var10, var10.isFaceSturdy(var1, var5, EnumDirection.WEST), EnumDirection.WEST);
        boolean var16 = this.connectsTo(var11, var11.isFaceSturdy(var1, var6, EnumDirection.NORTH), EnumDirection.NORTH);
        boolean var17 = this.connectsTo(var12, var12.isFaceSturdy(var1, var7, EnumDirection.EAST), EnumDirection.EAST);
        IBlockData var18 = (IBlockData)this.defaultBlockState().setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
        return this.updateShape(var1, var18, var8, var13, var14, var15, var16, var17);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        if (var4 == EnumDirection.DOWN) {
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        if (var4 == EnumDirection.UP) {
            return this.topUpdate(var1, var0, var5, var6);
        }
        return this.sideUpdate(var1, var3, var0, var5, var6, var4);
    }

    private static boolean isConnected(IBlockData var0, IBlockState<BlockPropertyWallHeight> var1) {
        return var0.getValue(var1) != BlockPropertyWallHeight.NONE;
    }

    private static boolean isCovered(VoxelShape var0, VoxelShape var1) {
        return !VoxelShapes.joinIsNotEmpty(var1, var0, OperatorBoolean.ONLY_FIRST);
    }

    private IBlockData topUpdate(IWorldReader var0, IBlockData var1, BlockPosition var2, IBlockData var3) {
        boolean var4 = BlockCobbleWall.isConnected(var1, NORTH_WALL);
        boolean var5 = BlockCobbleWall.isConnected(var1, EAST_WALL);
        boolean var6 = BlockCobbleWall.isConnected(var1, SOUTH_WALL);
        boolean var7 = BlockCobbleWall.isConnected(var1, WEST_WALL);
        return this.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    private IBlockData sideUpdate(IWorldReader var0, BlockPosition var1, IBlockData var2, BlockPosition var3, IBlockData var4, EnumDirection var5) {
        EnumDirection var6 = var5.getOpposite();
        boolean var7 = var5 == EnumDirection.NORTH ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, NORTH_WALL);
        boolean var8 = var5 == EnumDirection.EAST ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, EAST_WALL);
        boolean var9 = var5 == EnumDirection.SOUTH ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, SOUTH_WALL);
        boolean var10 = var5 == EnumDirection.WEST ? this.connectsTo(var4, var4.isFaceSturdy(var0, var3, var6), var6) : BlockCobbleWall.isConnected(var2, WEST_WALL);
        BlockPosition var11 = var1.above();
        IBlockData var12 = var0.getBlockState(var11);
        return this.updateShape(var0, var2, var11, var12, var7, var8, var9, var10);
    }

    private IBlockData updateShape(IWorldReader var0, IBlockData var1, BlockPosition var2, IBlockData var3, boolean var4, boolean var5, boolean var6, boolean var7) {
        VoxelShape var8 = var3.getCollisionShape(var0, var2).getFaceShape(EnumDirection.DOWN);
        IBlockData var9 = this.updateSides(var1, var4, var5, var6, var7, var8);
        return (IBlockData)var9.setValue(UP, this.shouldRaisePost(var9, var3, var8));
    }

    private boolean shouldRaisePost(IBlockData var0, IBlockData var1, VoxelShape var2) {
        boolean var13;
        boolean var12;
        boolean var3;
        boolean bl = var3 = var1.getBlock() instanceof BlockCobbleWall && var1.getValue(UP) != false;
        if (var3) {
            return true;
        }
        BlockPropertyWallHeight var4 = var0.getValue(NORTH_WALL);
        BlockPropertyWallHeight var5 = var0.getValue(SOUTH_WALL);
        BlockPropertyWallHeight var6 = var0.getValue(EAST_WALL);
        BlockPropertyWallHeight var7 = var0.getValue(WEST_WALL);
        boolean var8 = var5 == BlockPropertyWallHeight.NONE;
        boolean var9 = var7 == BlockPropertyWallHeight.NONE;
        boolean var10 = var6 == BlockPropertyWallHeight.NONE;
        boolean var11 = var4 == BlockPropertyWallHeight.NONE;
        boolean bl2 = var12 = var11 && var8 && var9 && var10 || var11 != var8 || var9 != var10;
        if (var12) {
            return true;
        }
        boolean bl3 = var13 = var4 == BlockPropertyWallHeight.TALL && var5 == BlockPropertyWallHeight.TALL || var6 == BlockPropertyWallHeight.TALL && var7 == BlockPropertyWallHeight.TALL;
        if (var13) {
            return false;
        }
        return var1.is(TagsBlock.WALL_POST_OVERRIDE) || BlockCobbleWall.isCovered(var2, POST_TEST);
    }

    private IBlockData updateSides(IBlockData var0, boolean var1, boolean var2, boolean var3, boolean var4, VoxelShape var5) {
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH_WALL, this.makeWallState(var1, var5, NORTH_TEST))).setValue(EAST_WALL, this.makeWallState(var2, var5, EAST_TEST))).setValue(SOUTH_WALL, this.makeWallState(var3, var5, SOUTH_TEST))).setValue(WEST_WALL, this.makeWallState(var4, var5, WEST_TEST));
    }

    private BlockPropertyWallHeight makeWallState(boolean var0, VoxelShape var1, VoxelShape var2) {
        if (var0) {
            if (BlockCobbleWall.isCovered(var1, var2)) {
                return BlockPropertyWallHeight.TALL;
            }
            return BlockPropertyWallHeight.LOW;
        }
        return BlockPropertyWallHeight.NONE;
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return var0.getValue(WATERLOGGED) == false;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH_WALL, var0.getValue(SOUTH_WALL))).setValue(EAST_WALL, var0.getValue(WEST_WALL))).setValue(SOUTH_WALL, var0.getValue(NORTH_WALL))).setValue(WEST_WALL, var0.getValue(EAST_WALL));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH_WALL, var0.getValue(EAST_WALL))).setValue(EAST_WALL, var0.getValue(SOUTH_WALL))).setValue(SOUTH_WALL, var0.getValue(WEST_WALL))).setValue(WEST_WALL, var0.getValue(NORTH_WALL));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH_WALL, var0.getValue(WEST_WALL))).setValue(EAST_WALL, var0.getValue(NORTH_WALL))).setValue(SOUTH_WALL, var0.getValue(EAST_WALL))).setValue(WEST_WALL, var0.getValue(SOUTH_WALL));
            }
        }
        return var0;
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH_WALL, var0.getValue(SOUTH_WALL))).setValue(SOUTH_WALL, var0.getValue(NORTH_WALL));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST_WALL, var0.getValue(WEST_WALL))).setValue(WEST_WALL, var0.getValue(EAST_WALL));
            }
        }
        return super.mirror(var0, var1);
    }
}

