/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.pathfinder.PathMode;

public class BlockChorusFruit
extends BlockSprawling {
    public static final MapCodec<BlockChorusFruit> CODEC = BlockChorusFruit.simpleCodec(BlockChorusFruit::new);

    public MapCodec<BlockChorusFruit> codec() {
        return CODEC;
    }

    protected BlockChorusFruit(BlockBase.Info var0) {
        super(0.3125f, var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(UP, false)).setValue(DOWN, false));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return BlockChorusFruit.getStateWithConnections(var0.getLevel(), var0.getClickedPos(), this.defaultBlockState());
    }

    public static IBlockData getStateWithConnections(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        IBlockData var3 = var0.getBlockState(var1.below());
        IBlockData var4 = var0.getBlockState(var1.above());
        IBlockData var5 = var0.getBlockState(var1.north());
        IBlockData var6 = var0.getBlockState(var1.east());
        IBlockData var7 = var0.getBlockState(var1.south());
        IBlockData var8 = var0.getBlockState(var1.west());
        Block var9 = var2.getBlock();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)var2.trySetValue(DOWN, var3.is(var9) || var3.is(Blocks.CHORUS_FLOWER) || var3.is(Blocks.END_STONE))).trySetValue(UP, var4.is(var9) || var4.is(Blocks.CHORUS_FLOWER))).trySetValue(NORTH, var5.is(var9) || var5.is(Blocks.CHORUS_FLOWER))).trySetValue(EAST, var6.is(var9) || var6.is(Blocks.CHORUS_FLOWER))).trySetValue(SOUTH, var7.is(var9) || var7.is(Blocks.CHORUS_FLOWER))).trySetValue(WEST, var8.is(var9) || var8.is(Blocks.CHORUS_FLOWER));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (!var0.canSurvive(var1, var3)) {
            var2.scheduleTick(var3, this, 1);
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        boolean var8 = var6.is(this) || var6.is(Blocks.CHORUS_FLOWER) || var4 == EnumDirection.DOWN && var6.is(Blocks.END_STONE);
        return (IBlockData)var0.setValue((IBlockState)PROPERTY_BY_DIRECTION.get(var4), var8);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.below());
        boolean var4 = !var1.getBlockState(var2.above()).isAir() && !var3.isAir();
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var7 = var2.relative(var6);
            IBlockData var8 = var1.getBlockState(var7);
            if (!var8.is(this)) continue;
            if (var4) {
                return false;
            }
            IBlockData var9 = var1.getBlockState(var7.below());
            if (!var9.is(this) && !var9.is(Blocks.END_STONE)) continue;
            return true;
        }
        return var3.is(this) || var3.is(Blocks.END_STONE);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(NORTH, EAST, SOUTH, WEST, UP, DOWN);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }
}

