/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockBannerWall
extends BlockBannerAbstract {
    public static final MapCodec<BlockBannerWall> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)EnumColor.CODEC.fieldOf("color").forGetter(BlockBannerAbstract::getColor), BlockBannerWall.propertiesCodec()).apply((Applicative)var0, BlockBannerWall::new));
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    private static final Map<EnumDirection, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.NORTH, (Object)Block.box(0.0, 0.0, 14.0, 16.0, 12.5, 16.0), (Object)EnumDirection.SOUTH, (Object)Block.box(0.0, 0.0, 0.0, 16.0, 12.5, 2.0), (Object)EnumDirection.WEST, (Object)Block.box(14.0, 0.0, 0.0, 16.0, 12.5, 16.0), (Object)EnumDirection.EAST, (Object)Block.box(0.0, 0.0, 0.0, 2.0, 12.5, 16.0)));

    public MapCodec<BlockBannerWall> codec() {
        return CODEC;
    }

    public BlockBannerWall(EnumColor var0, BlockBase.Info var1) {
        super(var0, var1);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.relative(var0.getValue(FACING).getOpposite())).isSolid();
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == var0.getValue(FACING).getOpposite() && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection[] var4;
        IBlockData var1 = this.defaultBlockState();
        World var2 = var0.getLevel();
        BlockPosition var3 = var0.getClickedPos();
        for (EnumDirection var8 : var4 = var0.getNearestLookingDirections()) {
            EnumDirection var9;
            if (!var8.getAxis().isHorizontal() || !(var1 = (IBlockData)var1.setValue(FACING, var9 = var8.getOpposite())).canSurvive(var2, var3)) continue;
            return var1;
        }
        return null;
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }
}

