/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.AbstractIterator;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.CursorPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class VoxelShapeSpliterator<T>
extends AbstractIterator<T> {
    private final AxisAlignedBB box;
    private final VoxelShapeCollision context;
    private final CursorPosition cursor;
    private final BlockPosition.MutableBlockPosition pos;
    private final VoxelShape entityShape;
    private final ICollisionAccess collisionGetter;
    private final boolean onlySuffocatingBlocks;
    @Nullable
    private IBlockAccess cachedBlockGetter;
    private long cachedBlockGetterPos;
    private final BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> resultProvider;

    public VoxelShapeSpliterator(ICollisionAccess var0, @Nullable Entity var1, AxisAlignedBB var2, boolean var3, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> var4) {
        this(var0, var1 == null ? VoxelShapeCollision.empty() : VoxelShapeCollision.of(var1), var2, var3, var4);
    }

    public VoxelShapeSpliterator(ICollisionAccess var0, VoxelShapeCollision var1, AxisAlignedBB var2, boolean var3, BiFunction<BlockPosition.MutableBlockPosition, VoxelShape, T> var4) {
        this.context = var1;
        this.pos = new BlockPosition.MutableBlockPosition();
        this.entityShape = VoxelShapes.create(var2);
        this.collisionGetter = var0;
        this.box = var2;
        this.onlySuffocatingBlocks = var3;
        this.resultProvider = var4;
        int var5 = MathHelper.floor(var2.minX - 1.0E-7) - 1;
        int var6 = MathHelper.floor(var2.maxX + 1.0E-7) + 1;
        int var7 = MathHelper.floor(var2.minY - 1.0E-7) - 1;
        int var8 = MathHelper.floor(var2.maxY + 1.0E-7) + 1;
        int var9 = MathHelper.floor(var2.minZ - 1.0E-7) - 1;
        int var10 = MathHelper.floor(var2.maxZ + 1.0E-7) + 1;
        this.cursor = new CursorPosition(var5, var7, var9, var6, var8, var10);
    }

    @Nullable
    private IBlockAccess getChunk(int var0, int var1) {
        IBlockAccess var6;
        int var2 = SectionPosition.blockToSectionCoord(var0);
        int var3 = SectionPosition.blockToSectionCoord(var1);
        long var4 = ChunkCoordIntPair.asLong(var2, var3);
        if (this.cachedBlockGetter != null && this.cachedBlockGetterPos == var4) {
            return this.cachedBlockGetter;
        }
        this.cachedBlockGetter = var6 = this.collisionGetter.getChunkForCollisions(var2, var3);
        this.cachedBlockGetterPos = var4;
        return var6;
    }

    protected T computeNext() {
        while (this.cursor.advance()) {
            IBlockAccess var4;
            int var0 = this.cursor.nextX();
            int var1 = this.cursor.nextY();
            int var2 = this.cursor.nextZ();
            int var3 = this.cursor.getNextType();
            if (var3 == 3 || (var4 = this.getChunk(var0, var2)) == null) continue;
            this.pos.set(var0, var1, var2);
            IBlockData var5 = var4.getBlockState(this.pos);
            if (this.onlySuffocatingBlocks && !var5.isSuffocating(var4, this.pos) || var3 == 1 && !var5.hasLargeCollisionShape() || var3 == 2 && !var5.is(Blocks.MOVING_PISTON)) continue;
            VoxelShape var6 = this.context.getCollisionShape(var5, this.collisionGetter, this.pos);
            if (var6 == VoxelShapes.block()) {
                if (!this.box.intersects(var0, var1, var2, (double)var0 + 1.0, (double)var1 + 1.0, (double)var2 + 1.0)) continue;
                return this.resultProvider.apply(this.pos, var6.move(var0, var1, var2));
            }
            VoxelShape var7 = var6.move(var0, var1, var2);
            if (var7.isEmpty() || !VoxelShapes.joinIsNotEmpty(var7, this.entityShape, OperatorBoolean.AND)) continue;
            return this.resultProvider.apply(this.pos, var7);
        }
        return (T)this.endOfData();
    }
}

