/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public class ServerExplosion
implements Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private static final float LARGE_EXPLOSION_RADIUS = 2.0f;
    private final boolean fire;
    private final Explosion.Effect blockInteraction;
    private final WorldServer level;
    private final Vec3D center;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final Map<EntityHuman, Vec3D> hitPlayers = new HashMap<EntityHuman, Vec3D>();

    public ServerExplosion(WorldServer var0, @Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, Vec3D var4, float var5, boolean var6, Explosion.Effect var7) {
        this.level = var0;
        this.source = var1;
        this.radius = var5;
        this.center = var4;
        this.fire = var6;
        this.blockInteraction = var7;
        this.damageSource = var2 == null ? var0.damageSources().explosion(this) : var2;
        this.damageCalculator = var3 == null ? this.makeDamageCalculator(var1) : var3;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity var0) {
        return var0 == null ? EXPLOSION_DAMAGE_CALCULATOR : new ExplosionDamageCalculatorEntity(var0);
    }

    public static float getSeenPercent(Vec3D var0, Entity var1) {
        AxisAlignedBB var2 = var1.getBoundingBox();
        double var3 = 1.0 / ((var2.maxX - var2.minX) * 2.0 + 1.0);
        double var5 = 1.0 / ((var2.maxY - var2.minY) * 2.0 + 1.0);
        double var7 = 1.0 / ((var2.maxZ - var2.minZ) * 2.0 + 1.0);
        double var9 = (1.0 - Math.floor(1.0 / var3) * var3) / 2.0;
        double var11 = (1.0 - Math.floor(1.0 / var7) * var7) / 2.0;
        if (var3 < 0.0 || var5 < 0.0 || var7 < 0.0) {
            return 0.0f;
        }
        int var13 = 0;
        int var14 = 0;
        for (double var15 = 0.0; var15 <= 1.0; var15 += var3) {
            for (double var17 = 0.0; var17 <= 1.0; var17 += var5) {
                for (double var19 = 0.0; var19 <= 1.0; var19 += var7) {
                    double var21 = MathHelper.lerp(var15, var2.minX, var2.maxX);
                    double var23 = MathHelper.lerp(var17, var2.minY, var2.maxY);
                    double var25 = MathHelper.lerp(var19, var2.minZ, var2.maxZ);
                    Vec3D var27 = new Vec3D(var21 + var9, var23, var25 + var11);
                    if (var1.level().clip(new RayTrace(var27, var0, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var1)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
                        ++var13;
                    }
                    ++var14;
                }
            }
        }
        return (float)var13 / (float)var14;
    }

    @Override
    public float radius() {
        return this.radius;
    }

    @Override
    public Vec3D center() {
        return this.center;
    }

    private List<BlockPosition> calculateExplodedPositions() {
        HashSet<BlockPosition> var0 = new HashSet<BlockPosition>();
        int var1 = 16;
        for (int var2 = 0; var2 < 16; ++var2) {
            for (int var3 = 0; var3 < 16; ++var3) {
                block2: for (int var4 = 0; var4 < 16; ++var4) {
                    if (var2 != 0 && var2 != 15 && var3 != 0 && var3 != 15 && var4 != 0 && var4 != 15) continue;
                    double var5 = (float)var2 / 15.0f * 2.0f - 1.0f;
                    double var7 = (float)var3 / 15.0f * 2.0f - 1.0f;
                    double var9 = (float)var4 / 15.0f * 2.0f - 1.0f;
                    double var11 = Math.sqrt(var5 * var5 + var7 * var7 + var9 * var9);
                    var5 /= var11;
                    var7 /= var11;
                    var9 /= var11;
                    double var14 = this.center.x;
                    double var16 = this.center.y;
                    double var18 = this.center.z;
                    float var20 = 0.3f;
                    for (float var13 = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); var13 > 0.0f; var13 -= 0.22500001f) {
                        BlockPosition var21 = BlockPosition.containing(var14, var16, var18);
                        IBlockData var22 = this.level.getBlockState(var21);
                        Fluid var23 = this.level.getFluidState(var21);
                        if (!this.level.isInWorldBounds(var21)) continue block2;
                        Optional<Float> var24 = this.damageCalculator.getBlockExplosionResistance(this, this.level, var21, var22, var23);
                        if (var24.isPresent()) {
                            var13 -= (var24.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (var13 > 0.0f && this.damageCalculator.shouldBlockExplode(this, this.level, var21, var22, var13)) {
                            var0.add(var21);
                        }
                        var14 += var5 * (double)0.3f;
                        var16 += var7 * (double)0.3f;
                        var18 += var9 * (double)0.3f;
                    }
                }
            }
        }
        return new ObjectArrayList(var0);
    }

    private void hurtEntities() {
        float var0 = this.radius * 2.0f;
        int var1 = MathHelper.floor(this.center.x - (double)var0 - 1.0);
        int var2 = MathHelper.floor(this.center.x + (double)var0 + 1.0);
        int var3 = MathHelper.floor(this.center.y - (double)var0 - 1.0);
        int var4 = MathHelper.floor(this.center.y + (double)var0 + 1.0);
        int var5 = MathHelper.floor(this.center.z - (double)var0 - 1.0);
        int var6 = MathHelper.floor(this.center.z + (double)var0 + 1.0);
        List<Entity> var7 = this.level.getEntities(this.source, new AxisAlignedBB(var1, var3, var5, var2, var4, var6));
        for (Entity var9 : var7) {
            EntityHuman var28;
            double var25;
            Object var27;
            float var22;
            double var16;
            double var14;
            double var12;
            double var18;
            double var10;
            if (var9.ignoreExplosion(this) || !((var10 = Math.sqrt(var9.distanceToSqr(this.center)) / (double)var0) <= 1.0) || (var18 = Math.sqrt((var12 = var9.getX() - this.center.x) * var12 + (var14 = (var9 instanceof EntityTNTPrimed ? var9.getY() : var9.getEyeY()) - this.center.y) * var14 + (var16 = var9.getZ() - this.center.z) * var16)) == 0.0) continue;
            var12 /= var18;
            var14 /= var18;
            var16 /= var18;
            boolean var20 = this.damageCalculator.shouldDamageEntity(this, var9);
            float var21 = this.damageCalculator.getKnockbackMultiplier(var9);
            float f2 = var22 = var20 || var21 != 0.0f ? ServerExplosion.getSeenPercent(this.center, var9) : 0.0f;
            if (var20) {
                var9.hurtServer(this.level, this.damageSource, this.damageCalculator.getEntityDamageAmount(this, var9, var22));
            }
            double var23 = (1.0 - var10) * (double)var22 * (double)var21;
            if (var9 instanceof EntityLiving) {
                var27 = (EntityLiving)var9;
                var25 = var23 * (1.0 - ((EntityLiving)var27).getAttributeValue(GenericAttributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                var25 = var23;
            }
            var27 = new Vec3D(var12 *= var25, var14 *= var25, var16 *= var25);
            var9.setDeltaMovement(var9.getDeltaMovement().add((Vec3D)var27));
            if (!(!(var9 instanceof EntityHuman) || (var28 = (EntityHuman)var9).isSpectator() || var28.isCreative() && var28.getAbilities().flying)) {
                this.hitPlayers.put(var28, (Vec3D)var27);
            }
            var9.onExplosionHit(this.source);
        }
    }

    private void interactWithBlocks(List<BlockPosition> var0) {
        ArrayList var12 = new ArrayList();
        SystemUtils.shuffle(var0, this.level.random);
        for (BlockPosition blockPosition : var0) {
            this.level.getBlockState(blockPosition).onExplosionHit(this.level, blockPosition, this, (var1, var2) -> ServerExplosion.addOrAppendStack(var12, var1, var2));
        }
        for (a a2 : var12) {
            Block.popResource((World)this.level, a2.pos, a2.stack);
        }
    }

    private void createFire(List<BlockPosition> var0) {
        for (BlockPosition var2 : var0) {
            if (this.level.random.nextInt(3) != 0 || !this.level.getBlockState(var2).isAir() || !this.level.getBlockState(var2.below()).isSolidRender()) continue;
            this.level.setBlockAndUpdate(var2, BlockFireAbstract.getState(this.level, var2));
        }
    }

    public void explode() {
        this.level.gameEvent(this.source, GameEvent.EXPLODE, this.center);
        List<BlockPosition> var0 = this.calculateExplodedPositions();
        this.hurtEntities();
        if (this.interactsWithBlocks()) {
            GameProfilerFiller var1 = Profiler.get();
            var1.push("explosion_blocks");
            this.interactWithBlocks(var0);
            var1.pop();
        }
        if (this.fire) {
            this.createFire(var0);
        }
    }

    private static void addOrAppendStack(List<a> var0, ItemStack var1, BlockPosition var2) {
        for (a var4 : var0) {
            var4.tryMerge(var1);
            if (!var1.isEmpty()) continue;
            return;
        }
        var0.add(new a(var2, var1));
    }

    private boolean interactsWithBlocks() {
        return this.blockInteraction != Explosion.Effect.KEEP;
    }

    public Map<EntityHuman, Vec3D> getHitPlayers() {
        return this.hitPlayers;
    }

    @Override
    public WorldServer level() {
        return this.level;
    }

    @Override
    @Nullable
    public EntityLiving getIndirectSourceEntity() {
        return Explosion.getIndirectSourceEntity(this.source);
    }

    @Override
    @Nullable
    public Entity getDirectSourceEntity() {
        return this.source;
    }

    @Override
    public Explosion.Effect getBlockInteraction() {
        return this.blockInteraction;
    }

    @Override
    public boolean canTriggerBlocks() {
        if (this.blockInteraction != Explosion.Effect.TRIGGER_BLOCK) {
            return false;
        }
        if (this.source != null && this.source.getType() == EntityTypes.BREEZE_WIND_CHARGE) {
            return this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        }
        return true;
    }

    @Override
    public boolean shouldAffectBlocklikeEntities() {
        boolean var2;
        boolean var0 = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        boolean var1 = this.source == null || !this.source.isInWater();
        boolean bl = var2 = this.source == null || this.source.getType() != EntityTypes.BREEZE_WIND_CHARGE && this.source.getType() != EntityTypes.WIND_CHARGE;
        if (var0) {
            return var1 && var2;
        }
        return this.blockInteraction.shouldAffectBlocklikeEntities() && var1 && var2;
    }

    public boolean isSmall() {
        return this.radius < 2.0f || !this.interactsWithBlocks();
    }

    static class a {
        final BlockPosition pos;
        ItemStack stack;

        a(BlockPosition var0, ItemStack var1) {
            this.pos = var0;
            this.stack = var1;
        }

        public void tryMerge(ItemStack var0) {
            if (EntityItem.areMergable(this.stack, var0)) {
                this.stack = EntityItem.merge(this.stack, var0, 16);
            }
        }
    }
}

