/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBlockAccess
extends LevelHeightAccessor {
    public static final int MAX_BLOCK_ITERATIONS_ALONG_TRAVEL = 16;

    @Nullable
    public TileEntity getBlockEntity(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> getBlockEntity(BlockPosition var0, TileEntityTypes<T> var1) {
        TileEntity var2 = this.getBlockEntity(var0);
        if (var2 == null || var2.getType() != var1) {
            return Optional.empty();
        }
        return Optional.of(var2);
    }

    public IBlockData getBlockState(BlockPosition var1);

    public Fluid getFluidState(BlockPosition var1);

    default public int getLightEmission(BlockPosition var0) {
        return this.getBlockState(var0).getLightEmission();
    }

    default public Stream<IBlockData> getBlockStates(AxisAlignedBB var0) {
        return BlockPosition.betweenClosedStream(var0).map(this::getBlockState);
    }

    default public MovingObjectPositionBlock isBlockInLine(ClipBlockStateContext var02) {
        return IBlockAccess.traverseBlocks(var02.getFrom(), var02.getTo(), var02, (var0, var1) -> {
            IBlockData var2 = this.getBlockState((BlockPosition)var1);
            Vec3D var3 = var0.getFrom().subtract(var0.getTo());
            return var0.isTargetBlock().test(var2) ? new MovingObjectPositionBlock(var0.getTo(), EnumDirection.getApproximateNearest(var3.x, var3.y, var3.z), BlockPosition.containing(var0.getTo()), false) : null;
        }, var0 -> {
            Vec3D var1 = var0.getFrom().subtract(var0.getTo());
            return MovingObjectPositionBlock.miss(var0.getTo(), EnumDirection.getApproximateNearest(var1.x, var1.y, var1.z), BlockPosition.containing(var0.getTo()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace var02) {
        return IBlockAccess.traverseBlocks(var02.getFrom(), var02.getTo(), var02, (var0, var1) -> {
            IBlockData var2 = this.getBlockState((BlockPosition)var1);
            Fluid var3 = this.getFluidState((BlockPosition)var1);
            Vec3D var4 = var0.getFrom();
            Vec3D var5 = var0.getTo();
            VoxelShape var6 = var0.getBlockShape(var2, this, (BlockPosition)var1);
            MovingObjectPositionBlock var7 = this.clipWithInteractionOverride(var4, var5, (BlockPosition)var1, var6, var2);
            VoxelShape var8 = var0.getFluidShape(var3, this, (BlockPosition)var1);
            MovingObjectPositionBlock var9 = var8.clip(var4, var5, (BlockPosition)var1);
            double var10 = var7 == null ? Double.MAX_VALUE : var0.getFrom().distanceToSqr(var7.getLocation());
            double var12 = var9 == null ? Double.MAX_VALUE : var0.getFrom().distanceToSqr(var9.getLocation());
            return var10 <= var12 ? var7 : var9;
        }, var0 -> {
            Vec3D var1 = var0.getFrom().subtract(var0.getTo());
            return MovingObjectPositionBlock.miss(var0.getTo(), EnumDirection.getApproximateNearest(var1.x, var1.y, var1.z), BlockPosition.containing(var0.getTo()));
        });
    }

    @Nullable
    default public MovingObjectPositionBlock clipWithInteractionOverride(Vec3D var0, Vec3D var1, BlockPosition var2, VoxelShape var3, IBlockData var4) {
        MovingObjectPositionBlock var6;
        MovingObjectPositionBlock var5 = var3.clip(var0, var1, var2);
        if (var5 != null && (var6 = var4.getInteractionShape(this, var2).clip(var0, var1, var2)) != null && var6.getLocation().subtract(var0).lengthSqr() < var5.getLocation().subtract(var0).lengthSqr()) {
            return var5.withDirection(var6.getDirection());
        }
        return var5;
    }

    default public double getBlockFloorHeight(VoxelShape var0, Supplier<VoxelShape> var1) {
        if (!var0.isEmpty()) {
            return var0.max(EnumDirection.EnumAxis.Y);
        }
        double var2 = var1.get().max(EnumDirection.EnumAxis.Y);
        if (var2 >= 1.0) {
            return var2 - 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    default public double getBlockFloorHeight(BlockPosition var0) {
        return this.getBlockFloorHeight(this.getBlockState(var0).getCollisionShape(this, var0), () -> {
            BlockPosition var1 = var0.below();
            return this.getBlockState(var1).getCollisionShape(this, var1);
        });
    }

    public static <T, C> T traverseBlocks(Vec3D var0, Vec3D var1, C var2, BiFunction<C, BlockPosition, T> var3, Function<C, T> var4) {
        int var19;
        int var18;
        if (var0.equals(var1)) {
            return var4.apply(var2);
        }
        double var5 = MathHelper.lerp(-1.0E-7, var1.x, var0.x);
        double var7 = MathHelper.lerp(-1.0E-7, var1.y, var0.y);
        double var9 = MathHelper.lerp(-1.0E-7, var1.z, var0.z);
        double var11 = MathHelper.lerp(-1.0E-7, var0.x, var1.x);
        double var13 = MathHelper.lerp(-1.0E-7, var0.y, var1.y);
        double var15 = MathHelper.lerp(-1.0E-7, var0.z, var1.z);
        int var17 = MathHelper.floor(var11);
        BlockPosition.MutableBlockPosition var20 = new BlockPosition.MutableBlockPosition(var17, var18 = MathHelper.floor(var13), var19 = MathHelper.floor(var15));
        T var21 = var3.apply(var2, var20);
        if (var21 != null) {
            return var21;
        }
        double var22 = var5 - var11;
        double var24 = var7 - var13;
        double var26 = var9 - var15;
        int var28 = MathHelper.sign(var22);
        int var29 = MathHelper.sign(var24);
        int var30 = MathHelper.sign(var26);
        double var31 = var28 == 0 ? Double.MAX_VALUE : (double)var28 / var22;
        double var33 = var29 == 0 ? Double.MAX_VALUE : (double)var29 / var24;
        double var35 = var30 == 0 ? Double.MAX_VALUE : (double)var30 / var26;
        double var37 = var31 * (var28 > 0 ? 1.0 - MathHelper.frac(var11) : MathHelper.frac(var11));
        double var39 = var33 * (var29 > 0 ? 1.0 - MathHelper.frac(var13) : MathHelper.frac(var13));
        double var41 = var35 * (var30 > 0 ? 1.0 - MathHelper.frac(var15) : MathHelper.frac(var15));
        while (var37 <= 1.0 || var39 <= 1.0 || var41 <= 1.0) {
            T var43;
            if (var37 < var39) {
                if (var37 < var41) {
                    var17 += var28;
                    var37 += var31;
                } else {
                    var19 += var30;
                    var41 += var35;
                }
            } else if (var39 < var41) {
                var18 += var29;
                var39 += var33;
            } else {
                var19 += var30;
                var41 += var35;
            }
            if ((var43 = var3.apply(var2, var20.set(var17, var18, var19))) == null) continue;
            return var43;
        }
        return var4.apply(var2);
    }

    public static Iterable<BlockPosition> boxTraverseBlocks(Vec3D var0, Vec3D var1, AxisAlignedBB var2) {
        Vec3D var3 = var1.subtract(var0);
        Iterable<BlockPosition> var4 = BlockPosition.betweenClosed(var2);
        if (var3.lengthSqr() < (double)MathHelper.square(0.99999f)) {
            return var4;
        }
        ObjectLinkedOpenHashSet var5 = new ObjectLinkedOpenHashSet();
        Vec3D var6 = var3.normalize().scale(1.0E-7);
        Vec3D var7 = var2.getMinPosition().add(var6);
        Vec3D var8 = var2.getMinPosition().subtract(var3).subtract(var6);
        IBlockAccess.addCollisionsAlongTravel((Set<BlockPosition>)var5, var8, var7, var2);
        for (BlockPosition var10 : var4) {
            var5.add(var10.immutable());
        }
        return var5;
    }

    private static void addCollisionsAlongTravel(Set<BlockPosition> var0, Vec3D var1, Vec3D var2, AxisAlignedBB var3) {
        Vec3D var4 = var2.subtract(var1);
        int var5 = MathHelper.floor(var1.x);
        int var6 = MathHelper.floor(var1.y);
        int var7 = MathHelper.floor(var1.z);
        int var8 = MathHelper.sign(var4.x);
        int var9 = MathHelper.sign(var4.y);
        int var10 = MathHelper.sign(var4.z);
        double var11 = var8 == 0 ? Double.MAX_VALUE : (double)var8 / var4.x;
        double var13 = var9 == 0 ? Double.MAX_VALUE : (double)var9 / var4.y;
        double var15 = var10 == 0 ? Double.MAX_VALUE : (double)var10 / var4.z;
        double var17 = var11 * (var8 > 0 ? 1.0 - MathHelper.frac(var1.x) : MathHelper.frac(var1.x));
        double var19 = var13 * (var9 > 0 ? 1.0 - MathHelper.frac(var1.y) : MathHelper.frac(var1.y));
        double var21 = var15 * (var10 > 0 ? 1.0 - MathHelper.frac(var1.z) : MathHelper.frac(var1.z));
        int var23 = 0;
        while (var17 <= 1.0 || var19 <= 1.0 || var21 <= 1.0) {
            if (var17 < var19) {
                if (var17 < var21) {
                    var5 += var8;
                    var17 += var11;
                } else {
                    var7 += var10;
                    var21 += var15;
                }
            } else if (var19 < var21) {
                var6 += var9;
                var19 += var13;
            } else {
                var7 += var10;
                var21 += var15;
            }
            if (var23++ > 16) break;
            Optional<Vec3D> var24 = AxisAlignedBB.clip(var5, var6, var7, var5 + 1, var6 + 1, var7 + 1, var1, var2);
            if (var24.isEmpty()) continue;
            Vec3D var25 = var24.get();
            double var26 = MathHelper.clamp(var25.x, (double)var5 + (double)1.0E-5f, (double)var5 + 1.0 - (double)1.0E-5f);
            double var28 = MathHelper.clamp(var25.y, (double)var6 + (double)1.0E-5f, (double)var6 + 1.0 - (double)1.0E-5f);
            double var30 = MathHelper.clamp(var25.z, (double)var7 + (double)1.0E-5f, (double)var7 + 1.0 - (double)1.0E-5f);
            int var32 = MathHelper.floor(var26 + var3.getXsize());
            int var33 = MathHelper.floor(var28 + var3.getYsize());
            int var34 = MathHelper.floor(var30 + var3.getZsize());
            for (int var35 = var5; var35 <= var32; ++var35) {
                for (int var36 = var6; var36 <= var33; ++var36) {
                    for (int var37 = var7; var37 <= var34; ++var37) {
                        var0.add(new BlockPosition(var35, var36, var37));
                    }
                }
            }
        }
    }
}

