/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.phys.Vec3D;

public abstract class CommandBlockListenerAbstract
implements ICommandListener {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final IChatBaseComponent DEFAULT_NAME = IChatBaseComponent.literal("@");
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable
    private IChatBaseComponent lastOutput;
    private String command = "";
    @Nullable
    private IChatBaseComponent customName;

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int var0) {
        this.successCount = var0;
    }

    public IChatBaseComponent getLastOutput() {
        return this.lastOutput == null ? CommonComponents.EMPTY : this.lastOutput;
    }

    public NBTTagCompound save(NBTTagCompound var0, HolderLookup.a var1) {
        var0.putString("Command", this.command);
        var0.putInt("SuccessCount", this.successCount);
        if (this.customName != null) {
            var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.customName, var1));
        }
        var0.putBoolean("TrackOutput", this.trackOutput);
        if (this.lastOutput != null && this.trackOutput) {
            var0.putString("LastOutput", IChatBaseComponent.ChatSerializer.toJson(this.lastOutput, var1));
        }
        var0.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution > 0L) {
            var0.putLong("LastExecution", this.lastExecution);
        }
        return var0;
    }

    public void load(NBTTagCompound var0, HolderLookup.a var1) {
        this.command = var0.getString("Command");
        this.successCount = var0.getInt("SuccessCount");
        if (var0.contains("CustomName", 8)) {
            this.setCustomName(TileEntity.parseCustomNameSafe(var0.getString("CustomName"), var1));
        } else {
            this.setCustomName(null);
        }
        if (var0.contains("TrackOutput", 1)) {
            this.trackOutput = var0.getBoolean("TrackOutput");
        }
        if (var0.contains("LastOutput", 8) && this.trackOutput) {
            try {
                this.lastOutput = IChatBaseComponent.ChatSerializer.fromJson(var0.getString("LastOutput"), var1);
            }
            catch (Throwable var2) {
                this.lastOutput = IChatBaseComponent.literal(var2.getMessage());
            }
        } else {
            this.lastOutput = null;
        }
        if (var0.contains("UpdateLastExecution")) {
            this.updateLastExecution = var0.getBoolean("UpdateLastExecution");
        }
        this.lastExecution = this.updateLastExecution && var0.contains("LastExecution") ? var0.getLong("LastExecution") : -1L;
    }

    public void setCommand(String var0) {
        this.command = var0;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean performCommand(World var02) {
        if (var02.isClientSide || var02.getGameTime() == this.lastExecution) {
            return false;
        }
        if ("Searge".equalsIgnoreCase(this.command)) {
            this.lastOutput = IChatBaseComponent.literal("#itzlipofutzli");
            this.successCount = 1;
            return true;
        }
        this.successCount = 0;
        MinecraftServer var12 = this.getLevel().getServer();
        if (var12.isCommandBlockEnabled() && !UtilColor.isNullOrEmpty(this.command)) {
            try {
                this.lastOutput = null;
                CommandListenerWrapper var2 = this.createCommandSourceStack().withCallback((var0, var1) -> {
                    if (var0) {
                        ++this.successCount;
                    }
                });
                var12.getCommands().performPrefixedCommand(var2, this.command);
            }
            catch (Throwable var2) {
                CrashReport var3 = CrashReport.forThrowable(var2, "Executing command block");
                CrashReportSystemDetails var4 = var3.addCategory("Command to be executed");
                var4.setDetail("Command", this::getCommand);
                var4.setDetail("Name", () -> this.getName().getString());
                throw new ReportedException(var3);
            }
        }
        this.lastExecution = this.updateLastExecution ? var02.getGameTime() : -1L;
        return true;
    }

    public IChatBaseComponent getName() {
        return this.customName != null ? this.customName : DEFAULT_NAME;
    }

    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable IChatBaseComponent var0) {
        this.customName = var0;
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent var0) {
        if (this.trackOutput) {
            this.lastOutput = IChatBaseComponent.literal("[" + TIME_FORMAT.format(new Date()) + "] ").append(var0);
            this.onUpdated();
        }
    }

    public abstract WorldServer getLevel();

    public abstract void onUpdated();

    public void setLastOutput(@Nullable IChatBaseComponent var0) {
        this.lastOutput = var0;
    }

    public void setTrackOutput(boolean var0) {
        this.trackOutput = var0;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public EnumInteractionResult usedBy(EntityHuman var0) {
        if (!var0.canUseGameMasterBlocks()) {
            return EnumInteractionResult.PASS;
        }
        if (var0.getCommandSenderWorld().isClientSide) {
            var0.openMinecartCommandBlock(this);
        }
        return EnumInteractionResult.SUCCESS;
    }

    public abstract Vec3D getPosition();

    public abstract CommandListenerWrapper createCommandSourceStack();

    @Override
    public boolean acceptsSuccess() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK) && this.trackOutput;
    }

    @Override
    public boolean acceptsFailure() {
        return this.trackOutput;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.getLevel().getGameRules().getBoolean(GameRules.RULE_COMMANDBLOCKOUTPUT);
    }

    public abstract boolean isValid();
}

