/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment.trim;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.equipment.EquipmentModel;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public record ArmorTrim(Holder<TrimMaterial> material, Holder<TrimPattern> pattern, boolean showInTooltip) implements TooltipProvider
{
    public static final Codec<ArmorTrim> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)TrimMaterial.CODEC.fieldOf("material").forGetter(ArmorTrim::material), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(ArmorTrim::pattern), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(var0 -> var0.showInTooltip)).apply((Applicative)var02, ArmorTrim::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ArmorTrim> STREAM_CODEC = StreamCodec.composite(TrimMaterial.STREAM_CODEC, ArmorTrim::material, TrimPattern.STREAM_CODEC, ArmorTrim::pattern, ByteBufCodecs.BOOL, var0 -> var0.showInTooltip, ArmorTrim::new);
    private static final IChatBaseComponent UPGRADE_TITLE = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("item", MinecraftKey.withDefaultNamespace("smithing_template.upgrade"))).withStyle(EnumChatFormat.GRAY);

    public ArmorTrim(Holder<TrimMaterial> var0, Holder<TrimPattern> var1) {
        this(var0, var1, true);
    }

    private static String getColorPaletteSuffix(Holder<TrimMaterial> var0, MinecraftKey var1) {
        String var2 = var0.value().overrideArmorMaterials().get(var1);
        if (var2 != null) {
            return var2;
        }
        return var0.value().assetName();
    }

    public boolean hasPatternAndMaterial(Holder<TrimPattern> var0, Holder<TrimMaterial> var1) {
        return var0.equals(this.pattern) && var1.equals(this.material);
    }

    public MinecraftKey getTexture(EquipmentModel.d var0, MinecraftKey var1) {
        MinecraftKey var22 = this.pattern.value().assetId();
        String var3 = ArmorTrim.getColorPaletteSuffix(this.material, var1);
        return var22.withPath(var2 -> "trims/entity/" + var0.getSerializedName() + "/" + var2 + "_" + var3);
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2) {
        if (!this.showInTooltip) {
            return;
        }
        var1.accept(UPGRADE_TITLE);
        var1.accept(CommonComponents.space().append(this.pattern.value().copyWithStyle(this.material)));
        var1.accept(CommonComponents.space().append(this.material.value().description()));
    }

    public ArmorTrim withTooltip(boolean var0) {
        return new ArmorTrim(this.material, this.pattern, var0);
    }
}

