/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.equipment.EquipmentModel;

public interface EquipmentModels {
    public static final MinecraftKey LEATHER = MinecraftKey.withDefaultNamespace("leather");
    public static final MinecraftKey CHAINMAIL = MinecraftKey.withDefaultNamespace("chainmail");
    public static final MinecraftKey IRON = MinecraftKey.withDefaultNamespace("iron");
    public static final MinecraftKey GOLD = MinecraftKey.withDefaultNamespace("gold");
    public static final MinecraftKey DIAMOND = MinecraftKey.withDefaultNamespace("diamond");
    public static final MinecraftKey TURTLE_SCUTE = MinecraftKey.withDefaultNamespace("turtle_scute");
    public static final MinecraftKey NETHERITE = MinecraftKey.withDefaultNamespace("netherite");
    public static final MinecraftKey ARMADILLO_SCUTE = MinecraftKey.withDefaultNamespace("armadillo_scute");
    public static final MinecraftKey ELYTRA = MinecraftKey.withDefaultNamespace("elytra");
    public static final Map<EnumColor, MinecraftKey> CARPETS = SystemUtils.makeEnumMap(EnumColor.class, var0 -> MinecraftKey.withDefaultNamespace(var0.getSerializedName() + "_carpet"));
    public static final MinecraftKey TRADER_LLAMA = MinecraftKey.withDefaultNamespace("trader_llama");

    public static void bootstrap(BiConsumer<MinecraftKey, EquipmentModel> var0) {
        var0.accept(LEATHER, EquipmentModel.builder().addHumanoidLayers(MinecraftKey.withDefaultNamespace("leather"), true).addHumanoidLayers(MinecraftKey.withDefaultNamespace("leather_overlay"), false).addLayers(EquipmentModel.d.HORSE_BODY, EquipmentModel.c.leatherDyeable(MinecraftKey.withDefaultNamespace("leather"), true)).build());
        var0.accept(CHAINMAIL, EquipmentModels.onlyHumanoid("chainmail"));
        var0.accept(IRON, EquipmentModels.humanoidAndHorse("iron"));
        var0.accept(GOLD, EquipmentModels.humanoidAndHorse("gold"));
        var0.accept(DIAMOND, EquipmentModels.humanoidAndHorse("diamond"));
        var0.accept(TURTLE_SCUTE, EquipmentModel.builder().addMainHumanoidLayer(MinecraftKey.withDefaultNamespace("turtle_scute"), false).build());
        var0.accept(NETHERITE, EquipmentModels.onlyHumanoid("netherite"));
        var0.accept(ARMADILLO_SCUTE, EquipmentModel.builder().addLayers(EquipmentModel.d.WOLF_BODY, EquipmentModel.c.onlyIfDyed(MinecraftKey.withDefaultNamespace("armadillo_scute"), false)).addLayers(EquipmentModel.d.WOLF_BODY, EquipmentModel.c.onlyIfDyed(MinecraftKey.withDefaultNamespace("armadillo_scute_overlay"), true)).build());
        var0.accept(ELYTRA, EquipmentModel.builder().addLayers(EquipmentModel.d.WINGS, new EquipmentModel.c(MinecraftKey.withDefaultNamespace("elytra"), Optional.empty(), true)).build());
        for (Map.Entry<EnumColor, MinecraftKey> var2 : CARPETS.entrySet()) {
            EnumColor var3 = var2.getKey();
            MinecraftKey var4 = var2.getValue();
            var0.accept(var4, EquipmentModel.builder().addLayers(EquipmentModel.d.LLAMA_BODY, new EquipmentModel.c(MinecraftKey.withDefaultNamespace(var3.getSerializedName()))).build());
        }
        var0.accept(TRADER_LLAMA, EquipmentModel.builder().addLayers(EquipmentModel.d.LLAMA_BODY, new EquipmentModel.c(MinecraftKey.withDefaultNamespace("trader_llama"))).build());
    }

    private static EquipmentModel onlyHumanoid(String var0) {
        return EquipmentModel.builder().addHumanoidLayers(MinecraftKey.withDefaultNamespace(var0)).build();
    }

    private static EquipmentModel humanoidAndHorse(String var0) {
        return EquipmentModel.builder().addHumanoidLayers(MinecraftKey.withDefaultNamespace(var0)).addLayers(EquipmentModel.d.HORSE_BODY, EquipmentModel.c.leatherDyeable(MinecraftKey.withDefaultNamespace(var0), false)).build();
    }
}

