/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;

public record EquipmentModel(Map<d, List<c>> layers) {
    private static final Codec<List<c>> LAYER_LIST_CODEC = ExtraCodecs.nonEmptyList(c.CODEC.listOf());
    public static final Codec<EquipmentModel> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.nonEmptyMap(Codec.unboundedMap(d.CODEC, LAYER_LIST_CODEC)).fieldOf("layers").forGetter(EquipmentModel::layers)).apply((Applicative)var0, EquipmentModel::new));

    public static a builder() {
        return new a();
    }

    public List<c> getLayers(d var0) {
        return this.layers.getOrDefault(var0, List.of());
    }

    public static class a {
        private final Map<d, List<c>> layersByType = new EnumMap<d, List<c>>(d.class);

        a() {
        }

        public a addHumanoidLayers(MinecraftKey var0) {
            return this.addHumanoidLayers(var0, false);
        }

        public a addHumanoidLayers(MinecraftKey var0, boolean var1) {
            this.addLayers(d.HUMANOID_LEGGINGS, c.leatherDyeable(var0, var1));
            this.addMainHumanoidLayer(var0, var1);
            return this;
        }

        public a addMainHumanoidLayer(MinecraftKey var0, boolean var1) {
            return this.addLayers(d.HUMANOID, c.leatherDyeable(var0, var1));
        }

        public a addLayers(d var02, c ... var1) {
            Collections.addAll(this.layersByType.computeIfAbsent(var02, var0 -> new ArrayList()), var1);
            return this;
        }

        public EquipmentModel build() {
            return new EquipmentModel((Map)this.layersByType.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> List.copyOf((Collection)var0.getValue()))));
        }
    }

    public static final class d
    extends Enum<d>
    implements INamable {
        public static final /* enum */ d HUMANOID = new d("humanoid");
        public static final /* enum */ d HUMANOID_LEGGINGS = new d("humanoid_leggings");
        public static final /* enum */ d WINGS = new d("wings");
        public static final /* enum */ d WOLF_BODY = new d("wolf_body");
        public static final /* enum */ d HORSE_BODY = new d("horse_body");
        public static final /* enum */ d LLAMA_BODY = new d("llama_body");
        public static final Codec<d> CODEC;
        private final String id;
        private static final /* synthetic */ d[] i;

        public static d[] values() {
            return (d[])i.clone();
        }

        public static d valueOf(String var0) {
            return Enum.valueOf(d.class, var0);
        }

        private d(String var2) {
            this.id = var2;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        private static /* synthetic */ d[] a() {
            return new d[]{HUMANOID, HUMANOID_LEGGINGS, WINGS, WOLF_BODY, HORSE_BODY, LLAMA_BODY};
        }

        static {
            i = d.a();
            CODEC = INamable.fromEnum(d::values);
        }
    }

    public record c(MinecraftKey textureId, Optional<b> dyeable, boolean usePlayerTexture) {
        public static final Codec<c> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("texture").forGetter(c::textureId), (App)b.CODEC.optionalFieldOf("dyeable").forGetter(c::dyeable), (App)Codec.BOOL.optionalFieldOf("use_player_texture", (Object)false).forGetter(c::usePlayerTexture)).apply((Applicative)var0, c::new));

        public c(MinecraftKey var0) {
            this(var0, Optional.empty(), false);
        }

        public static c leatherDyeable(MinecraftKey var0, boolean var1) {
            return new c(var0, var1 ? Optional.of(new b(Optional.of(-6265536))) : Optional.empty(), false);
        }

        public static c onlyIfDyed(MinecraftKey var0, boolean var1) {
            return new c(var0, var1 ? Optional.of(new b(Optional.empty())) : Optional.empty(), false);
        }

        public MinecraftKey getTextureLocation(d var0) {
            return this.textureId.withPath(var1 -> "textures/entity/equipment/" + var0.getSerializedName() + "/" + var1 + ".png");
        }
    }

    public record b(Optional<Integer> colorWhenUndyed) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.RGB_COLOR_CODEC.optionalFieldOf("color_when_undyed").forGetter(b::colorWhenUndyed)).apply((Applicative)var0, b::new));
    }
}

