/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public record ArmorMaterial(int durability, Map<ArmorType, Integer> defense, int enchantmentValue, Holder<SoundEffect> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient, MinecraftKey modelId) {
    public Item.Info humanoidProperties(Item.Info var0, ArmorType var1) {
        return var0.durability(var1.getDurability(this.durability)).attributes(this.createAttributes(var1)).enchantable(this.enchantmentValue).component(DataComponents.EQUIPPABLE, Equippable.builder(var1.getSlot()).setEquipSound(this.equipSound).setModel(this.modelId).build()).repairable(this.repairIngredient);
    }

    public Item.Info animalProperties(Item.Info var0, HolderSet<EntityTypes<?>> var1) {
        return var0.durability(ArmorType.BODY.getDurability(this.durability)).attributes(this.createAttributes(ArmorType.BODY)).repairable(this.repairIngredient).component(DataComponents.EQUIPPABLE, Equippable.builder(EnumItemSlot.BODY).setEquipSound(this.equipSound).setModel(this.modelId).setAllowedEntities(var1).build());
    }

    public Item.Info animalProperties(Item.Info var0, Holder<SoundEffect> var1, boolean var2, HolderSet<EntityTypes<?>> var3) {
        if (var2) {
            var0 = var0.durability(ArmorType.BODY.getDurability(this.durability)).repairable(this.repairIngredient);
        }
        return var0.attributes(this.createAttributes(ArmorType.BODY)).component(DataComponents.EQUIPPABLE, Equippable.builder(EnumItemSlot.BODY).setEquipSound(var1).setModel(this.modelId).setAllowedEntities(var3).setDamageOnHurt(var2).build());
    }

    private ItemAttributeModifiers createAttributes(ArmorType var0) {
        int var1 = this.defense.getOrDefault(var0, 0);
        ItemAttributeModifiers.a var2 = ItemAttributeModifiers.builder();
        EquipmentSlotGroup var3 = EquipmentSlotGroup.bySlot(var0.getSlot());
        MinecraftKey var4 = MinecraftKey.withDefaultNamespace("armor." + var0.getName());
        var2.add(GenericAttributes.ARMOR, new AttributeModifier(var4, var1, AttributeModifier.Operation.ADD_VALUE), var3);
        var2.add(GenericAttributes.ARMOR_TOUGHNESS, new AttributeModifier(var4, this.toughness, AttributeModifier.Operation.ADD_VALUE), var3);
        if (this.knockbackResistance > 0.0f) {
            var2.add(GenericAttributes.KNOCKBACK_RESISTANCE, new AttributeModifier(var4, this.knockbackResistance, AttributeModifier.Operation.ADD_VALUE), var3);
        }
        return var2.build();
    }
}

