/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final Optional<RecipeItemStack> template;
    final Optional<RecipeItemStack> base;
    final Optional<RecipeItemStack> addition;
    @Nullable
    private PlacementInfo placementInfo;

    public SmithingTrimRecipe(Optional<RecipeItemStack> var0, Optional<RecipeItemStack> var1, Optional<RecipeItemStack> var2) {
        this.template = var0;
        this.base = var1;
        this.addition = var2;
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput var0, HolderLookup.a var1) {
        return SmithingTrimRecipe.applyTrim(var1, var0.base(), var0.addition(), var0.template());
    }

    public static ItemStack applyTrim(HolderLookup.a var0, ItemStack var1, ItemStack var2, ItemStack var3) {
        Optional<Holder.c<TrimMaterial>> var4 = TrimMaterials.getFromIngredient(var0, var2);
        Optional<Holder.c<TrimPattern>> var5 = TrimPatterns.getFromTemplate(var0, var3);
        if (var4.isPresent() && var5.isPresent()) {
            ArmorTrim var6 = var1.get(DataComponents.TRIM);
            if (var6 != null && var6.hasPatternAndMaterial((Holder<TrimPattern>)var5.get(), (Holder<TrimMaterial>)var4.get())) {
                return ItemStack.EMPTY;
            }
            ItemStack var7 = var1.copyWithCount(1);
            var7.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)var4.get(), (Holder<TrimPattern>)var5.get()));
            return var7;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Optional<RecipeItemStack> templateIngredient() {
        return this.template;
    }

    @Override
    public Optional<RecipeItemStack> baseIngredient() {
        return this.base;
    }

    @Override
    public Optional<RecipeItemStack> additionIngredient() {
        return this.addition;
    }

    @Override
    public RecipeSerializer<SmithingTrimRecipe> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.template, this.base, this.addition));
        }
        return this.placementInfo;
    }

    @Override
    public List<RecipeDisplay> display() {
        SlotDisplay var0 = RecipeItemStack.optionalIngredientToDisplay(this.base);
        SlotDisplay var1 = RecipeItemStack.optionalIngredientToDisplay(this.addition);
        SlotDisplay var2 = RecipeItemStack.optionalIngredientToDisplay(this.template);
        return List.of(new SmithingRecipeDisplay(var2, var0, var1, new SlotDisplay.g(var0, var1, var2), new SlotDisplay.d(Items.SMITHING_TABLE)));
    }

    public static class a
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)RecipeItemStack.CODEC.optionalFieldOf("template").forGetter(var0 -> var0.template), (App)RecipeItemStack.CODEC.optionalFieldOf("base").forGetter(var0 -> var0.base), (App)RecipeItemStack.CODEC.optionalFieldOf("addition").forGetter(var0 -> var0.addition)).apply((Applicative)var02, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> STREAM_CODEC = StreamCodec.composite(RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.template, RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.base, RecipeItemStack.OPTIONAL_CONTENTS_STREAM_CODEC, var0 -> var0.addition, SmithingTrimRecipe::new);

        @Override
        public MapCodec<SmithingTrimRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

