/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeItemStack> CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(RecipeItemStack::new, var0 -> var0.values);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<RecipeItemStack>> OPTIONAL_CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(var0 -> var0.size() == 0 ? Optional.empty() : Optional.of(new RecipeItemStack((HolderSet<Item>)var0)), var02 -> var02.map(var0 -> var0.values).orElse(HolderSet.direct(new Holder[0])));
    public static final Codec<HolderSet<Item>> NON_AIR_HOLDER_SET_CODEC = HolderSetCodec.create(Registries.ITEM, Item.CODEC, false);
    public static final Codec<RecipeItemStack> CODEC = ExtraCodecs.nonEmptyHolderSet(NON_AIR_HOLDER_SET_CODEC).xmap(RecipeItemStack::new, var0 -> var0.values);
    private final HolderSet<Item> values;
    @Nullable
    private List<Holder<Item>> items;

    private RecipeItemStack(HolderSet<Item> var02) {
        var02.unwrap().ifRight(var0 -> {
            if (var0.isEmpty()) {
                throw new UnsupportedOperationException("Ingredients can't be empty");
            }
            if (var0.contains(Items.AIR.builtInRegistryHolder())) {
                throw new UnsupportedOperationException("Ingredient can't contain air");
            }
        });
        this.values = var02;
    }

    public static boolean testOptionalIngredient(Optional<RecipeItemStack> var0, ItemStack var12) {
        return var0.map(var1 -> var1.test(var12)).orElseGet(var12::isEmpty);
    }

    public List<Holder<Item>> items() {
        if (this.items == null) {
            this.items = ImmutableList.copyOf(this.values);
        }
        return this.items;
    }

    @Override
    public boolean test(ItemStack var0) {
        List<Holder<Item>> var1 = this.items();
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            if (!var0.is(var1.get(var2))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object var0) {
        if (var0 instanceof RecipeItemStack) {
            RecipeItemStack var1 = (RecipeItemStack)var0;
            return Objects.equals(this.values, var1.values);
        }
        return false;
    }

    public static RecipeItemStack of(IMaterial var0) {
        return new RecipeItemStack(HolderSet.direct(var0.asItem().builtInRegistryHolder()));
    }

    public static RecipeItemStack of(IMaterial ... var0) {
        return RecipeItemStack.of(Arrays.stream(var0));
    }

    public static RecipeItemStack of(Stream<? extends IMaterial> var02) {
        return new RecipeItemStack(HolderSet.direct(var02.map(var0 -> var0.asItem().builtInRegistryHolder()).toList()));
    }

    public static RecipeItemStack of(HolderSet<Item> var0) {
        return new RecipeItemStack(var0);
    }

    public SlotDisplay display() {
        return (SlotDisplay)this.values.unwrap().map(SlotDisplay.h::new, var0 -> new SlotDisplay.b(var0.stream().map(RecipeItemStack::displayForSingleItem).toList()));
    }

    public static SlotDisplay optionalIngredientToDisplay(Optional<RecipeItemStack> var0) {
        return var0.map(RecipeItemStack::display).orElse(SlotDisplay.c.INSTANCE);
    }

    private static SlotDisplay displayForSingleItem(Holder<Item> var0) {
        SlotDisplay.d var1 = new SlotDisplay.d(var0);
        ItemStack var2 = var0.value().getCraftingRemainder();
        if (!var2.isEmpty()) {
            SlotDisplay.f var3 = new SlotDisplay.f(var2);
            return new SlotDisplay.j(var1, var3);
        }
        return var1;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ItemStack)object);
    }
}

