/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeItemStack;

public class PlacementInfo {
    public static final PlacementInfo NOT_PLACEABLE = new PlacementInfo(List.of(), List.of(), List.of());
    private final List<RecipeItemStack> ingredients;
    private final List<AutoRecipeStackManager.a<Holder<Item>>> unpackedIngredients;
    private final List<Optional<a>> slotInfo;

    private PlacementInfo(List<RecipeItemStack> var0, List<AutoRecipeStackManager.a<Holder<Item>>> var1, List<Optional<a>> var2) {
        this.ingredients = var0;
        this.unpackedIngredients = var1;
        this.slotInfo = var2;
    }

    public static AutoRecipeStackManager.a<Holder<Item>> ingredientToContents(RecipeItemStack var0) {
        return StackedItemContents.convertIngredientContents(var0.items().stream());
    }

    public static PlacementInfo create(RecipeItemStack var0) {
        if (var0.items().isEmpty()) {
            return NOT_PLACEABLE;
        }
        AutoRecipeStackManager.a<Holder<Item>> var1 = PlacementInfo.ingredientToContents(var0);
        a var2 = new a(0);
        return new PlacementInfo(List.of(var0), List.of(var1), List.of(Optional.of(var2)));
    }

    public static PlacementInfo createFromOptionals(List<Optional<RecipeItemStack>> var0) {
        int var1 = var0.size();
        ArrayList<RecipeItemStack> var2 = new ArrayList<RecipeItemStack>(var1);
        ArrayList<AutoRecipeStackManager.a<Holder<Item>>> var3 = new ArrayList<AutoRecipeStackManager.a<Holder<Item>>>(var1);
        ArrayList<Optional<a>> var4 = new ArrayList<Optional<a>>(var1);
        int var5 = 0;
        for (Optional<RecipeItemStack> var7 : var0) {
            if (var7.isPresent()) {
                RecipeItemStack var8 = var7.get();
                if (var8.items().isEmpty()) {
                    return NOT_PLACEABLE;
                }
                var2.add(var8);
                var3.add(PlacementInfo.ingredientToContents(var8));
                var4.add(Optional.of(new a(var5++)));
                continue;
            }
            var4.add(Optional.empty());
        }
        return new PlacementInfo(var2, var3, var4);
    }

    public static PlacementInfo create(List<RecipeItemStack> var0) {
        int var1 = var0.size();
        ArrayList<AutoRecipeStackManager.a<Holder<Item>>> var2 = new ArrayList<AutoRecipeStackManager.a<Holder<Item>>>(var1);
        ArrayList<Optional<a>> var3 = new ArrayList<Optional<a>>(var1);
        for (int var4 = 0; var4 < var1; ++var4) {
            RecipeItemStack var5 = var0.get(var4);
            if (var5.items().isEmpty()) {
                return NOT_PLACEABLE;
            }
            var2.add(PlacementInfo.ingredientToContents(var5));
            var3.add(Optional.of(new a(var4)));
        }
        return new PlacementInfo(var0, var2, var3);
    }

    public List<Optional<a>> slotInfo() {
        return this.slotInfo;
    }

    public List<RecipeItemStack> ingredients() {
        return this.ingredients;
    }

    public List<AutoRecipeStackManager.a<Holder<Item>>> unpackedIngredients() {
        return this.unpackedIngredients;
    }

    public boolean isImpossibleToPlace() {
        return this.slotInfo.isEmpty();
    }

    public record a(int placerOutputPosition) {
    }
}

