/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.level.World;

public interface IRecipe<T extends RecipeInput> {
    public static final Codec<IRecipe<?>> CODEC = BuiltInRegistries.RECIPE_SERIALIZER.byNameCodec().dispatch(IRecipe::getSerializer, RecipeSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IRecipe<?>> STREAM_CODEC = ByteBufCodecs.registry(Registries.RECIPE_SERIALIZER).dispatch(IRecipe::getSerializer, RecipeSerializer::streamCodec);

    public boolean matches(T var1, World var2);

    public ItemStack assemble(T var1, HolderLookup.a var2);

    default public boolean isSpecial() {
        return false;
    }

    default public boolean showNotification() {
        return true;
    }

    default public String group() {
        return "";
    }

    public RecipeSerializer<? extends IRecipe<T>> getSerializer();

    public Recipes<? extends IRecipe<T>> getType();

    public PlacementInfo placementInfo();

    default public List<RecipeDisplay> display() {
        return List.of();
    }

    public RecipeBookCategory recipeBookCategory();
}

