/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class ItemContainerContents {
    private static final int NO_SLOT = -1;
    private static final int MAX_SIZE = 256;
    public static final ItemContainerContents EMPTY = new ItemContainerContents(NonNullList.create());
    public static final Codec<ItemContainerContents> CODEC = a.CODEC.sizeLimitedListOf(256).xmap(ItemContainerContents::fromSlots, ItemContainerContents::asSlots);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list(256)).map(ItemContainerContents::new, var0 -> var0.items);
    private final NonNullList<ItemStack> items;
    private final int hashCode;

    private ItemContainerContents(NonNullList<ItemStack> var0) {
        if (var0.size() > 256) {
            throw new IllegalArgumentException("Got " + var0.size() + " items, but maximum is 256");
        }
        this.items = var0;
        this.hashCode = ItemStack.hashStackList(var0);
    }

    private ItemContainerContents(int var0) {
        this(NonNullList.withSize(var0, ItemStack.EMPTY));
    }

    private ItemContainerContents(List<ItemStack> var0) {
        this(var0.size());
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            this.items.set(var1, var0.get(var1));
        }
    }

    private static ItemContainerContents fromSlots(List<a> var0) {
        OptionalInt var1 = var0.stream().mapToInt(a::index).max();
        if (var1.isEmpty()) {
            return EMPTY;
        }
        ItemContainerContents var2 = new ItemContainerContents(var1.getAsInt() + 1);
        for (a var4 : var0) {
            var2.items.set(var4.index(), var4.item());
        }
        return var2;
    }

    public static ItemContainerContents fromItems(List<ItemStack> var0) {
        int var1 = ItemContainerContents.findLastNonEmptySlot(var0);
        if (var1 == -1) {
            return EMPTY;
        }
        ItemContainerContents var2 = new ItemContainerContents(var1 + 1);
        for (int var3 = 0; var3 <= var1; ++var3) {
            var2.items.set(var3, var0.get(var3).copy());
        }
        return var2;
    }

    private static int findLastNonEmptySlot(List<ItemStack> var0) {
        for (int var1 = var0.size() - 1; var1 >= 0; --var1) {
            if (var0.get(var1).isEmpty()) continue;
            return var1;
        }
        return -1;
    }

    private List<a> asSlots() {
        ArrayList<a> var0 = new ArrayList<a>();
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            ItemStack var2 = this.items.get(var1);
            if (var2.isEmpty()) continue;
            var0.add(new a(var1, var2));
        }
        return var0;
    }

    public void copyInto(NonNullList<ItemStack> var0) {
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            ItemStack var2 = var1 < this.items.size() ? this.items.get(var1) : ItemStack.EMPTY;
            var0.set(var1, var2.copy());
        }
    }

    public ItemStack copyOne() {
        return this.items.isEmpty() ? ItemStack.EMPTY : this.items.get(0).copy();
    }

    public Stream<ItemStack> stream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Stream<ItemStack> nonEmptyStream() {
        return this.items.stream().filter(var0 -> !var0.isEmpty()).map(ItemStack::copy);
    }

    public Iterable<ItemStack> nonEmptyItems() {
        return Iterables.filter(this.items, var0 -> !var0.isEmpty());
    }

    public Iterable<ItemStack> nonEmptyItemsCopy() {
        return Iterables.transform(this.nonEmptyItems(), ItemStack::copy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ItemContainerContents)) return false;
        ItemContainerContents var1 = (ItemContainerContents)var0;
        if (!ItemStack.listMatches(this.items, var1.items)) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    record a(int index, ItemStack item) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(a::index), (App)ItemStack.CODEC.fieldOf("item").forGetter(a::item)).apply((Applicative)var0, a::new));
    }
}

