/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.Vec3D;

public class WindChargeItem
extends Item
implements ProjectileItem {
    public WindChargeItem(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var22) {
        ItemStack var32 = var1.getItemInHand(var22);
        if (var0 instanceof WorldServer) {
            WorldServer var42 = (WorldServer)var0;
            IProjectile.spawnProjectileFromRotation((var2, var3, var4) -> new WindCharge(var1, var0, var1.position().x(), var1.getEyePosition().y(), var1.position().z()), var42, var32, var1, 0.0f, 1.5f, 1.0f);
        }
        var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.WIND_CHARGE_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        var32.consume(1, var1);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        RandomSource var4 = var0.getRandom();
        double var5 = var4.triangle((double)var3.getStepX(), 0.11485000000000001);
        double var7 = var4.triangle((double)var3.getStepY(), 0.11485000000000001);
        double var9 = var4.triangle((double)var3.getStepZ(), 0.11485000000000001);
        Vec3D var11 = new Vec3D(var5, var7, var9);
        WindCharge var12 = new WindCharge(var0, var1.x(), var1.y(), var1.z(), var11);
        var12.setDeltaMovement(var11);
        return var12;
    }

    @Override
    public void shoot(IProjectile var0, double var1, double var3, double var5, float var7, float var8) {
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().positionFunction((var0, var1) -> BlockDispenser.getDispensePosition(var0, 1.0, Vec3D.ZERO)).uncertainty(6.6666665f).power(1.0f).overrideDispenseEvent(1051).build();
    }
}

