/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class ItemTrident
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public ItemTrident(Item.Info var0) {
        super(var0);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return !var3.isCreative();
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return 72000;
    }

    @Override
    public boolean releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
        if (!(var2 instanceof EntityHuman)) {
            return false;
        }
        EntityHuman var4 = (EntityHuman)var2;
        int var5 = this.getUseDuration(var0, var2) - var3;
        if (var5 < 10) {
            return false;
        }
        float var6 = EnchantmentManager.getTridentSpinAttackStrength(var0, var4);
        if (var6 > 0.0f && !var4.isInWaterOrRain()) {
            return false;
        }
        if (var0.nextDamageWillBreak()) {
            return false;
        }
        Holder<SoundEffect> var7 = EnchantmentManager.pickHighestLevel(var0, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEffects.TRIDENT_THROW);
        if (var1 instanceof WorldServer) {
            WorldServer var8 = (WorldServer)var1;
            var0.hurtWithoutBreaking(1, var4);
            if (var6 == 0.0f) {
                EntityThrownTrident var9 = IProjectile.spawnProjectileFromRotation(EntityThrownTrident::new, var8, var0, var4, 0.0f, 2.5f, 1.0f);
                if (var4.hasInfiniteMaterials()) {
                    var9.pickup = EntityArrow.PickupStatus.CREATIVE_ONLY;
                } else {
                    var4.getInventory().removeItem(var0);
                }
                var1.playSound(null, var9, var7.value(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                return true;
            }
        }
        var4.awardStat(StatisticList.ITEM_USED.get(this));
        if (var6 > 0.0f) {
            float var8 = var4.getYRot();
            float var9 = var4.getXRot();
            float var10 = -MathHelper.sin(var8 * ((float)Math.PI / 180)) * MathHelper.cos(var9 * ((float)Math.PI / 180));
            float var11 = -MathHelper.sin(var9 * ((float)Math.PI / 180));
            float var12 = MathHelper.cos(var8 * ((float)Math.PI / 180)) * MathHelper.cos(var9 * ((float)Math.PI / 180));
            float var13 = MathHelper.sqrt(var10 * var10 + var11 * var11 + var12 * var12);
            var4.push(var10 *= var6 / var13, var11 *= var6 / var13, var12 *= var6 / var13);
            var4.startAutoSpinAttack(20, 8.0f, var0);
            if (var4.onGround()) {
                float var14 = 1.1999999f;
                var4.move(EnumMoveType.SELF, new Vec3D(0.0, 1.1999999284744263, 0.0));
            }
            var1.playSound(null, var4, var7.value(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var3.nextDamageWillBreak()) {
            return EnumInteractionResult.FAIL;
        }
        if (EnchantmentManager.getTridentSpinAttackStrength(var3, var1) > 0.0f && !var1.isInWaterOrRain()) {
            return EnumInteractionResult.FAIL;
        }
        var1.startUsingItem(var2);
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public boolean hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        return true;
    }

    @Override
    public void postHurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        var0.hurtAndBreak(1, var2, EnumItemSlot.MAINHAND);
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        EntityThrownTrident var4 = new EntityThrownTrident(var0, var1.x(), var1.y(), var1.z(), var2.copyWithCount(1));
        var4.pickup = EntityArrow.PickupStatus.ALLOWED;
        return var4;
    }
}

