/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemSpade
extends ItemTool {
    protected static final Map<Block, IBlockData> FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)Blocks.GRASS_BLOCK, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.PODZOL, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.COARSE_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.MYCELIUM, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.ROOTED_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).build());

    public ItemSpade(ToolMaterial var0, float var1, float var2, Item.Info var3) {
        super(var0, TagsBlock.MINEABLE_WITH_SHOVEL, var1, var2, var3);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        IBlockData var3 = var1.getBlockState(var2);
        if (var0.getClickedFace() != EnumDirection.DOWN) {
            EntityHuman var4 = var0.getPlayer();
            IBlockData var5 = FLATTENABLES.get(var3.getBlock());
            IBlockData var6 = null;
            if (var5 != null && var1.getBlockState(var2.above()).isAir()) {
                var1.playSound(var4, var2, SoundEffects.SHOVEL_FLATTEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                var6 = var5;
            } else if (var3.getBlock() instanceof BlockCampfire && var3.getValue(BlockCampfire.LIT).booleanValue()) {
                if (!var1.isClientSide()) {
                    var1.levelEvent(null, 1009, var2, 0);
                }
                BlockCampfire.dowse(var0.getPlayer(), var1, var2, var3);
                var6 = (IBlockData)var3.setValue(BlockCampfire.LIT, false);
            }
            if (var6 != null) {
                if (!var1.isClientSide) {
                    var1.setBlock(var2, var6, 11);
                    var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var4, var6));
                    if (var4 != null) {
                        var0.getItemInHand().hurtAndBreak(1, var4, EntityLiving.getSlotForHand(var0.getHand()));
                    }
                }
                return EnumInteractionResult.SUCCESS;
            }
            return EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.PASS;
    }
}

