/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class ItemFireworks
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public ItemFireworks(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        if (var1 instanceof WorldServer) {
            WorldServer var2 = (WorldServer)var1;
            ItemStack var3 = var0.getItemInHand();
            Vec3D var4 = var0.getClickLocation();
            EnumDirection var5 = var0.getClickedFace();
            IProjectile.spawnProjectile(new EntityFireworks(var1, var0.getPlayer(), var4.x + (double)var5.getStepX() * 0.15, var4.y + (double)var5.getStepY() * 0.15, var4.z + (double)var5.getStepZ() * 0.15, var3), var2, var3);
            var3.shrink(1);
        }
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        if (var1.isFallFlying()) {
            ItemStack var3 = var1.getItemInHand(var2);
            if (var0 instanceof WorldServer) {
                WorldServer var4 = (WorldServer)var0;
                IProjectile.spawnProjectile(new EntityFireworks(var0, var3, var1), var4, var3);
                var3.consume(1, var1);
                var1.awardStat(StatisticList.ITEM_USED.get(this));
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        Fireworks var4 = var0.get(DataComponents.FIREWORKS);
        if (var4 != null) {
            var4.addToTooltip(var1, var2::add, var3);
        }
    }

    @Override
    public IProjectile asProjectile(World var0, IPosition var1, ItemStack var2, EnumDirection var3) {
        return new EntityFireworks(var0, var2.copyWithCount(1), var1.x(), var1.y(), var1.z(), true);
    }

    @Override
    public ProjectileItem.a createDispenseConfig() {
        return ProjectileItem.a.builder().positionFunction(ItemFireworks::getEntityJustOutsideOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3D getEntityJustOutsideOfBlockPos(SourceBlock var0, EnumDirection var1) {
        return var0.center().add((double)var1.getStepX() * 0.5000099999997474, (double)var1.getStepY() * 0.5000099999997474, (double)var1.getStepZ() * 0.5000099999997474);
    }
}

