/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ItemCrossbow
extends ItemProjectileWeapon {
    private static final float MAX_CHARGE_DURATION = 1.25f;
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private static final float START_SOUND_PERCENT = 0.2f;
    private static final float MID_SOUND_PERCENT = 0.5f;
    private static final float ARROW_POWER = 3.15f;
    private static final float FIREWORK_POWER = 1.6f;
    public static final float MOB_ARROW_POWER = 1.6f;
    private static final a DEFAULT_SOUNDS = new a(Optional.of(SoundEffects.CROSSBOW_LOADING_START), Optional.of(SoundEffects.CROSSBOW_LOADING_MIDDLE), Optional.of(SoundEffects.CROSSBOW_LOADING_END));

    public ItemCrossbow(Item.Info var0) {
        super(var0);
    }

    @Override
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return ARROW_OR_FIREWORK;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        ChargedProjectiles var4 = var3.get(DataComponents.CHARGED_PROJECTILES);
        if (var4 != null && !var4.isEmpty()) {
            this.performShooting(var0, var1, var2, var3, ItemCrossbow.getShootingPower(var4), 1.0f, null);
            return EnumInteractionResult.CONSUME;
        }
        if (!var1.getProjectile(var3).isEmpty()) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            var1.startUsingItem(var2);
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.FAIL;
    }

    private static float getShootingPower(ChargedProjectiles var0) {
        if (var0.contains(Items.FIREWORK_ROCKET)) {
            return 1.6f;
        }
        return 3.15f;
    }

    @Override
    public boolean releaseUsing(ItemStack var0, World var1, EntityLiving var22, int var3) {
        int var4 = this.getUseDuration(var0, var22) - var3;
        float var5 = ItemCrossbow.getPowerForTime(var4, var0, var22);
        if (var5 >= 1.0f && !ItemCrossbow.isCharged(var0) && ItemCrossbow.tryLoadProjectiles(var22, var0)) {
            a var6 = this.getChargingSounds(var0);
            var6.end().ifPresent(var2 -> var1.playSound(null, var22.getX(), var22.getY(), var22.getZ(), (SoundEffect)var2.value(), var22.getSoundSource(), 1.0f, 1.0f / (var1.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
            return true;
        }
        return false;
    }

    private static boolean tryLoadProjectiles(EntityLiving var0, ItemStack var1) {
        List<ItemStack> var2 = ItemCrossbow.draw(var1, var0.getProjectile(var1), var0);
        if (!var2.isEmpty()) {
            var1.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.of(var2));
            return true;
        }
        return false;
    }

    public static boolean isCharged(ItemStack var0) {
        ChargedProjectiles var1 = var0.getOrDefault(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        return !var1.isEmpty();
    }

    @Override
    protected void shootProjectile(EntityLiving var0, IProjectile var1, int var2, float var3, float var4, float var5, @Nullable EntityLiving var6) {
        Vector3f var7;
        if (var6 != null) {
            double var8 = var6.getX() - var0.getX();
            double var10 = var6.getZ() - var0.getZ();
            double var12 = Math.sqrt(var8 * var8 + var10 * var10);
            double var14 = var6.getY(0.3333333333333333) - var1.getY() + var12 * (double)0.2f;
            var7 = ItemCrossbow.getProjectileShotVector(var0, new Vec3D(var8, var14, var10), var5);
        } else {
            Vec3D var8 = var0.getUpVector(1.0f);
            Quaternionf var9 = new Quaternionf().setAngleAxis((double)(var5 * ((float)Math.PI / 180)), var8.x, var8.y, var8.z);
            Vec3D var10 = var0.getViewVector(1.0f);
            var7 = var10.toVector3f().rotate((Quaternionfc)var9);
        }
        var1.shoot(var7.x(), var7.y(), var7.z(), var3, var4);
        float var8 = ItemCrossbow.getShotPitch(var0.getRandom(), var2);
        var0.level().playSound(null, var0.getX(), var0.getY(), var0.getZ(), SoundEffects.CROSSBOW_SHOOT, var0.getSoundSource(), 1.0f, var8);
    }

    private static Vector3f getProjectileShotVector(EntityLiving var0, Vec3D var1, float var2) {
        Vec3D var5;
        Vector3f var3 = var1.toVector3f().normalize();
        Vector3f var4 = new Vector3f((Vector3fc)var3).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)var4.lengthSquared() <= 1.0E-7) {
            var5 = var0.getUpVector(1.0f);
            var4 = new Vector3f((Vector3fc)var3).cross((Vector3fc)var5.toVector3f());
        }
        var5 = new Vector3f((Vector3fc)var3).rotateAxis(1.5707964f, var4.x, var4.y, var4.z);
        return new Vector3f((Vector3fc)var3).rotateAxis(var2 * ((float)Math.PI / 180), ((Vector3f)var5).x, ((Vector3f)var5).y, ((Vector3f)var5).z);
    }

    @Override
    protected IProjectile createProjectile(World var0, EntityLiving var1, ItemStack var2, ItemStack var3, boolean var4) {
        if (var3.is(Items.FIREWORK_ROCKET)) {
            return new EntityFireworks(var0, var3, var1, var1.getX(), var1.getEyeY() - (double)0.15f, var1.getZ(), true);
        }
        IProjectile var5 = super.createProjectile(var0, var1, var2, var3, var4);
        if (var5 instanceof EntityArrow) {
            EntityArrow var6 = (EntityArrow)var5;
            var6.setSoundEvent(SoundEffects.CROSSBOW_HIT);
        }
        return var5;
    }

    @Override
    protected int getDurabilityUse(ItemStack var0) {
        return var0.is(Items.FIREWORK_ROCKET) ? 3 : 1;
    }

    public void performShooting(World var0, EntityLiving var1, EnumHand var2, ItemStack var3, float var4, float var5, @Nullable EntityLiving var6) {
        if (!(var0 instanceof WorldServer)) {
            return;
        }
        WorldServer var7 = (WorldServer)var0;
        ChargedProjectiles var8 = var3.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        if (var8 == null || var8.isEmpty()) {
            return;
        }
        this.shoot(var7, var1, var2, var3, var8.getItems(), var4, var5, var1 instanceof EntityHuman, var6);
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var9 = (EntityPlayer)var1;
            CriterionTriggers.SHOT_CROSSBOW.trigger(var9, var3);
            var9.awardStat(StatisticList.ITEM_USED.get(var3.getItem()));
        }
    }

    private static float getShotPitch(RandomSource var0, int var1) {
        if (var1 == 0) {
            return 1.0f;
        }
        return ItemCrossbow.getRandomShotPitch((var1 & 1) == 1, var0);
    }

    private static float getRandomShotPitch(boolean var0, RandomSource var1) {
        float var2 = var0 ? 0.63f : 0.43f;
        return 1.0f / (var1.nextFloat() * 0.5f + 1.8f) + var2;
    }

    @Override
    public void onUseTick(World var0, EntityLiving var1, ItemStack var22, int var3) {
        if (!var0.isClientSide) {
            a var4 = this.getChargingSounds(var22);
            float var5 = (float)(var22.getUseDuration(var1) - var3) / (float)ItemCrossbow.getChargeDuration(var22, var1);
            if (var5 < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (var5 >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                var4.start().ifPresent(var2 -> var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), (SoundEffect)var2.value(), SoundCategory.PLAYERS, 0.5f, 1.0f));
            }
            if (var5 >= 0.5f && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                var4.mid().ifPresent(var2 -> var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), (SoundEffect)var2.value(), SoundCategory.PLAYERS, 0.5f, 1.0f));
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return ItemCrossbow.getChargeDuration(var0, var1) + 3;
    }

    public static int getChargeDuration(ItemStack var0, EntityLiving var1) {
        float var2 = EnchantmentManager.modifyCrossbowChargingTime(var0, var1, 1.25f);
        return MathHelper.floor(var2 * 20.0f);
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.CROSSBOW;
    }

    a getChargingSounds(ItemStack var0) {
        return EnchantmentManager.pickHighestLevel(var0, EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS).orElse(DEFAULT_SOUNDS);
    }

    private static float getPowerForTime(int var0, ItemStack var1, EntityLiving var2) {
        float var3 = (float)var0 / (float)ItemCrossbow.getChargeDuration(var1, var2);
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3;
    }

    @Override
    public void appendHoverText(ItemStack var0, Item.b var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        ChargedProjectiles var4 = var0.get(DataComponents.CHARGED_PROJECTILES);
        if (var4 == null || var4.isEmpty()) {
            return;
        }
        ItemStack var5 = var4.getItems().get(0);
        var2.add(IChatBaseComponent.translatable("item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append(var5.getDisplayName()));
        if (var3.isAdvanced() && var5.is(Items.FIREWORK_ROCKET)) {
            ArrayList var6 = Lists.newArrayList();
            Items.FIREWORK_ROCKET.appendHoverText(var5, var1, var6, var3);
            if (!var6.isEmpty()) {
                for (int var7 = 0; var7 < var6.size(); ++var7) {
                    var6.set(var7, IChatBaseComponent.literal("  ").append((IChatBaseComponent)var6.get(var7)).withStyle(EnumChatFormat.GRAY));
                }
                var2.addAll(var6);
            }
        }
    }

    @Override
    public boolean useOnRelease(ItemStack var0) {
        return var0.is(this);
    }

    @Override
    public int getDefaultProjectileRange() {
        return 8;
    }

    public record a(Optional<Holder<SoundEffect>> start, Optional<Holder<SoundEffect>> mid, Optional<Holder<SoundEffect>> end) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)SoundEffect.CODEC.optionalFieldOf("start").forGetter(a::start), (App)SoundEffect.CODEC.optionalFieldOf("mid").forGetter(a::mid), (App)SoundEffect.CODEC.optionalFieldOf("end").forGetter(a::end)).apply((Applicative)var0, a::new));
    }
}

