/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class BrushItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;

    public BrushItem(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityHuman var1 = var0.getPlayer();
        if (var1 != null && this.calculateHitResult(var1).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            var1.startUsingItem(var0.getHand());
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        return ItemUseAnimation.BRUSH;
    }

    @Override
    public int getUseDuration(ItemStack var0, EntityLiving var1) {
        return 200;
    }

    @Override
    public void onUseTick(World var0, EntityLiving var1, ItemStack var2, int var3) {
        boolean var8;
        MovingObjectPositionBlock var6;
        EntityHuman var4;
        block11: {
            block10: {
                if (var3 < 0 || !(var1 instanceof EntityHuman)) {
                    var1.releaseUsingItem();
                    return;
                }
                var4 = (EntityHuman)var1;
                MovingObjectPosition var5 = this.calculateHitResult(var4);
                if (!(var5 instanceof MovingObjectPositionBlock)) break block10;
                var6 = (MovingObjectPositionBlock)var5;
                if (var5.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) break block11;
            }
            var1.releaseUsingItem();
            return;
        }
        int var7 = this.getUseDuration(var2, var1) - var3 + 1;
        boolean bl = var8 = var7 % 10 == 5;
        if (var8) {
            SoundEffect var12;
            Object var13;
            Block block;
            EnumMainHand var11;
            BlockPosition var9 = var6.getBlockPos();
            IBlockData var10 = var0.getBlockState(var9);
            EnumMainHand enumMainHand = var11 = var1.getUsedItemHand() == EnumHand.MAIN_HAND ? var4.getMainArm() : var4.getMainArm().getOpposite();
            if (var10.shouldSpawnTerrainParticles() && var10.getRenderShape() != EnumRenderType.INVISIBLE) {
                this.spawnDustParticles(var0, var6, var10, var1.getViewVector(0.0f), var11);
            }
            if ((block = var10.getBlock()) instanceof BrushableBlock) {
                var13 = (BrushableBlock)block;
                var12 = ((BrushableBlock)var13).getBrushSound();
            } else {
                var12 = SoundEffects.BRUSH_GENERIC;
            }
            var0.playSound(var4, var9, var12, SoundCategory.BLOCKS);
            if (var0 instanceof WorldServer) {
                BrushableBlockEntity var14;
                boolean var15;
                var13 = (WorldServer)var0;
                TileEntity tileEntity = var0.getBlockEntity(var9);
                if (tileEntity instanceof BrushableBlockEntity && (var15 = (var14 = (BrushableBlockEntity)tileEntity).brush(var0.getGameTime(), (WorldServer)var13, var4, var6.getDirection(), var2))) {
                    EnumItemSlot var16 = var2.equals(var4.getItemBySlot(EnumItemSlot.OFFHAND)) ? EnumItemSlot.OFFHAND : EnumItemSlot.MAINHAND;
                    var2.hurtAndBreak(1, var4, var16);
                }
            }
        }
    }

    private MovingObjectPosition calculateHitResult(EntityHuman var0) {
        return ProjectileHelper.getHitResultOnViewVector(var0, IEntitySelector.CAN_BE_PICKED, var0.blockInteractionRange());
    }

    private void spawnDustParticles(World var0, MovingObjectPositionBlock var1, IBlockData var2, Vec3D var3, EnumMainHand var4) {
        double var5 = 3.0;
        int var7 = var4 == EnumMainHand.RIGHT ? 1 : -1;
        int var8 = var0.getRandom().nextInt(7, 12);
        ParticleParamBlock var9 = new ParticleParamBlock(Particles.BLOCK, var2);
        EnumDirection var10 = var1.getDirection();
        a var11 = a.fromDirection(var3, var10);
        Vec3D var12 = var1.getLocation();
        for (int var13 = 0; var13 < var8; ++var13) {
            var0.addParticle(var9, var12.x - (double)(var10 == EnumDirection.WEST ? 1.0E-6f : 0.0f), var12.y, var12.z - (double)(var10 == EnumDirection.NORTH ? 1.0E-6f : 0.0f), var11.xd() * (double)var7 * 3.0 * var0.getRandom().nextDouble(), 0.0, var11.zd() * (double)var7 * 3.0 * var0.getRandom().nextDouble());
        }
    }

    record a(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static a fromDirection(Vec3D var0, EnumDirection var1) {
            double var2 = 0.0;
            return switch (var1) {
                default -> throw new MatchException(null, null);
                case EnumDirection.DOWN, EnumDirection.UP -> new a(var0.z(), 0.0, -var0.x());
                case EnumDirection.NORTH -> new a(1.0, 0.0, -0.1);
                case EnumDirection.SOUTH -> new a(-1.0, 0.0, 0.1);
                case EnumDirection.WEST -> new a(-0.1, 0.0, -1.0);
                case EnumDirection.EAST -> new a(0.1, 0.0, 1.0);
            };
        }
    }
}

