/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.MerchantWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryMerchant;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotMerchantResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;

public class ContainerMerchant
extends Container {
    protected static final int PAYMENT1_SLOT = 0;
    protected static final int PAYMENT2_SLOT = 1;
    protected static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private static final int SELLSLOT1_X = 136;
    private static final int SELLSLOT2_X = 162;
    private static final int BUYSLOT_X = 220;
    private static final int ROW_Y = 37;
    private final IMerchant trader;
    private final InventoryMerchant tradeContainer;
    private int merchantLevel;
    private boolean showProgressBar;
    private boolean canRestock;

    public ContainerMerchant(int var0, PlayerInventory var1) {
        this(var0, var1, new MerchantWrapper(var1.player));
    }

    public ContainerMerchant(int var0, PlayerInventory var1, IMerchant var2) {
        super(Containers.MERCHANT, var0);
        this.trader = var2;
        this.tradeContainer = new InventoryMerchant(var2);
        this.addSlot(new Slot(this.tradeContainer, 0, 136, 37));
        this.addSlot(new Slot(this.tradeContainer, 1, 162, 37));
        this.addSlot(new SlotMerchantResult(var1.player, var2, this.tradeContainer, 2, 220, 37));
        this.addStandardInventorySlots(var1, 108, 84);
    }

    public void setShowProgressBar(boolean var0) {
        this.showProgressBar = var0;
    }

    @Override
    public void slotsChanged(IInventory var0) {
        this.tradeContainer.updateSellItem();
        super.slotsChanged(var0);
    }

    public void setSelectionHint(int var0) {
        this.tradeContainer.setSelectionHint(var0);
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.trader.getTradingPlayer() == var0;
    }

    public int getTraderXp() {
        return this.trader.getVillagerXp();
    }

    public int getFutureTraderXp() {
        return this.tradeContainer.getFutureXp();
    }

    public void setXp(int var0) {
        this.trader.overrideXp(var0);
    }

    public int getTraderLevel() {
        return this.merchantLevel;
    }

    public void setMerchantLevel(int var0) {
        this.merchantLevel = var0;
    }

    public void setCanRestock(boolean var0) {
        this.canRestock = var0;
    }

    public boolean canRestock() {
        return this.canRestock;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return false;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 2) {
                if (!this.moveItemStackTo(var4, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
                this.playTradeSound();
            } else if (var1 == 0 || var1 == 1 ? !this.moveItemStackTo(var4, 3, 39, false) : (var1 >= 3 && var1 < 30 ? !this.moveItemStackTo(var4, 30, 39, false) : var1 >= 30 && var1 < 39 && !this.moveItemStackTo(var4, 3, 30, false))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    private void playTradeSound() {
        if (!this.trader.isClientSide()) {
            Entity var0 = (Entity)((Object)this.trader);
            var0.level().playLocalSound(var0.getX(), var0.getY(), var0.getZ(), this.trader.getNotifyTradeSound(), SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.trader.setTradingPlayer(null);
        if (this.trader.isClientSide()) {
            return;
        }
        if (!var0.isAlive() || var0 instanceof EntityPlayer && ((EntityPlayer)var0).hasDisconnected()) {
            ItemStack var1 = this.tradeContainer.removeItemNoUpdate(0);
            if (!var1.isEmpty()) {
                var0.drop(var1, false);
            }
            if (!(var1 = this.tradeContainer.removeItemNoUpdate(1)).isEmpty()) {
                var0.drop(var1, false);
            }
        } else if (var0 instanceof EntityPlayer) {
            var0.getInventory().placeItemBackInInventory(this.tradeContainer.removeItemNoUpdate(0));
            var0.getInventory().placeItemBackInInventory(this.tradeContainer.removeItemNoUpdate(1));
        }
    }

    public void tryMoveItems(int var02) {
        ItemStack var2;
        if (var02 < 0 || this.getOffers().size() <= var02) {
            return;
        }
        ItemStack var1 = this.tradeContainer.getItem(0);
        if (!var1.isEmpty()) {
            if (!this.moveItemStackTo(var1, 3, 39, true)) {
                return;
            }
            this.tradeContainer.setItem(0, var1);
        }
        if (!(var2 = this.tradeContainer.getItem(1)).isEmpty()) {
            if (!this.moveItemStackTo(var2, 3, 39, true)) {
                return;
            }
            this.tradeContainer.setItem(1, var2);
        }
        if (this.tradeContainer.getItem(0).isEmpty() && this.tradeContainer.getItem(1).isEmpty()) {
            MerchantRecipe var3 = (MerchantRecipe)this.getOffers().get(var02);
            this.moveFromInventoryToPaymentSlot(0, var3.getItemCostA());
            var3.getItemCostB().ifPresent(var0 -> this.moveFromInventoryToPaymentSlot(1, (ItemCost)var0));
        }
    }

    private void moveFromInventoryToPaymentSlot(int var0, ItemCost var1) {
        for (int var2 = 3; var2 < 39; ++var2) {
            ItemStack var4;
            ItemStack var3 = ((Slot)this.slots.get(var2)).getItem();
            if (var3.isEmpty() || !var1.test(var3) || !(var4 = this.tradeContainer.getItem(var0)).isEmpty() && !ItemStack.isSameItemSameComponents(var3, var4)) continue;
            int var5 = var3.getMaxStackSize();
            int var6 = Math.min(var5 - var4.getCount(), var3.getCount());
            ItemStack var7 = var3.copyWithCount(var4.getCount() + var6);
            var3.shrink(var6);
            this.tradeContainer.setItem(var0, var7);
            if (var7.getCount() >= var5) break;
        }
    }

    public void setOffers(MerchantRecipeList var0) {
        this.trader.overrideOffers(var0);
    }

    public MerchantRecipeList getOffers() {
        return this.trader.getOffers();
    }

    public boolean showProgressBar() {
        return this.showProgressBar;
    }
}

