/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.level.GameRules;

public class FoodMetaData {
    public int foodLevel = 20;
    public float saturationLevel = 5.0f;
    public float exhaustionLevel;
    private int tickTimer;

    private void add(int var0, float var1) {
        this.foodLevel = MathHelper.clamp(var0 + this.foodLevel, 0, 20);
        this.saturationLevel = MathHelper.clamp(var1 + this.saturationLevel, 0.0f, (float)this.foodLevel);
    }

    public void eat(int var0, float var1) {
        this.add(var0, FoodConstants.saturationByModifier(var0, var1));
    }

    public void eat(FoodInfo var0) {
        this.add(var0.nutrition(), var0.saturation());
    }

    public void tick(EntityPlayer var0) {
        boolean var3;
        WorldServer var1 = var0.serverLevel();
        EnumDifficulty var2 = var1.getDifficulty();
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
            } else if (var2 != EnumDifficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if ((var3 = var1.getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) && this.saturationLevel > 0.0f && var0.isHurt() && this.foodLevel >= 20) {
            ++this.tickTimer;
            if (this.tickTimer >= 10) {
                float var4 = Math.min(this.saturationLevel, 6.0f);
                var0.heal(var4 / 6.0f);
                this.addExhaustion(var4);
                this.tickTimer = 0;
            }
        } else if (var3 && this.foodLevel >= 18 && var0.isHurt()) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                var0.heal(1.0f);
                this.addExhaustion(6.0f);
                this.tickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                if (var0.getHealth() > 10.0f || var2 == EnumDifficulty.HARD || var0.getHealth() > 1.0f && var2 == EnumDifficulty.NORMAL) {
                    var0.hurtServer(var1, var0.damageSources().starve(), 1.0f);
                }
                this.tickTimer = 0;
            }
        } else {
            this.tickTimer = 0;
        }
    }

    public void readAdditionalSaveData(NBTTagCompound var0) {
        if (var0.contains("foodLevel", 99)) {
            this.foodLevel = var0.getInt("foodLevel");
            this.tickTimer = var0.getInt("foodTickTimer");
            this.saturationLevel = var0.getFloat("foodSaturationLevel");
            this.exhaustionLevel = var0.getFloat("foodExhaustionLevel");
        }
    }

    public void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putInt("foodLevel", this.foodLevel);
        var0.putInt("foodTickTimer", this.tickTimer);
        var0.putFloat("foodSaturationLevel", this.saturationLevel);
        var0.putFloat("foodExhaustionLevel", this.exhaustionLevel);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public boolean needsFood() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float var0) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + var0, 40.0f);
    }

    public float getSaturationLevel() {
        return this.saturationLevel;
    }

    public void setFoodLevel(int var0) {
        this.foodLevel = var0;
    }

    public void setSaturation(float var0) {
        this.saturationLevel = var0;
    }
}

