/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private static final byte EVENT_PRIME = 10;
    private static final String TAG_EXPLOSION_POWER = "explosion_power";
    private static final float DEFAULT_EXPLOSION_POWER_BASE = 4.0f;
    public int fuse = -1;
    public float explosionPowerBase = 4.0f;

    public EntityMinecartTNT(EntityTypes<? extends EntityMinecartTNT> var0, World var1) {
        super(var0, var1);
    }

    @Override
    public IBlockData getDefaultDisplayBlockState() {
        return Blocks.TNT.defaultBlockState();
    }

    @Override
    public void tick() {
        double var0;
        super.tick();
        if (this.fuse > 0) {
            --this.fuse;
            this.level().addParticle(Particles.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.getDeltaMovement().horizontalDistanceSqr());
        }
        if (this.horizontalCollision && (var0 = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
            this.explode(var0);
        }
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        EntityArrow var4;
        Entity var3 = var1.getDirectEntity();
        if (var3 instanceof EntityArrow && (var4 = (EntityArrow)var3).isOnFire()) {
            DamageSource var5 = this.damageSources().explosion(this, var1.getEntity());
            this.explode(var5, var4.getDeltaMovement().lengthSqr());
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    public void destroy(WorldServer var0, DamageSource var1) {
        double var2 = this.getDeltaMovement().horizontalDistanceSqr();
        if (EntityMinecartTNT.damageSourceIgnitesTnt(var1) || var2 >= (double)0.01f) {
            if (this.fuse < 0) {
                this.primeFuse();
                this.fuse = this.random.nextInt(20) + this.random.nextInt(20);
            }
            return;
        }
        this.destroy(var0, this.getDropItem());
    }

    @Override
    protected Item getDropItem() {
        return Items.TNT_MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.TNT_MINECART);
    }

    public void explode(double var0) {
        this.explode(null, var0);
    }

    protected void explode(@Nullable DamageSource var0, double var1) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var3 = (WorldServer)world;
            double var4 = Math.min(Math.sqrt(var1), 5.0);
            var3.explode(this, var0, null, this.getX(), this.getY(), this.getZ(), (float)((double)this.explosionPowerBase + this.random.nextDouble() * 1.5 * var4), false, World.a.TNT);
            this.discard();
        }
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        if (var0 >= 3.0f) {
            float var3 = var0 / 10.0f;
            this.explode(var3 * var3);
        }
        return super.causeFallDamage(var0, var1, var2);
    }

    @Override
    public void activateMinecart(int var0, int var1, int var2, boolean var3) {
        if (var3 && this.fuse < 0) {
            this.primeFuse();
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 10) {
            this.primeFuse();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public void primeFuse() {
        this.fuse = 80;
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent(this, (byte)10);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    @Override
    public float getBlockExplosionResistance(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, Fluid var4, float var5) {
        if (this.isPrimed() && (var3.is(TagsBlock.RAILS) || var1.getBlockState(var2.above()).is(TagsBlock.RAILS))) {
            return 0.0f;
        }
        return super.getBlockExplosionResistance(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean shouldBlockExplode(Explosion var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, float var4) {
        if (this.isPrimed() && (var3.is(TagsBlock.RAILS) || var1.getBlockState(var2.above()).is(TagsBlock.RAILS))) {
            return false;
        }
        return super.shouldBlockExplode(var0, var1, var2, var3, var4);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("TNTFuse", 99)) {
            this.fuse = var0.getInt("TNTFuse");
        }
        if (var0.contains(TAG_EXPLOSION_POWER, 99)) {
            this.explosionPowerBase = MathHelper.clamp(var0.getFloat(TAG_EXPLOSION_POWER), 0.0f, 128.0f);
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("TNTFuse", this.fuse);
        if (this.explosionPowerBase != 4.0f) {
            var0.putFloat(TAG_EXPLOSION_POWER, this.explosionPowerBase);
        }
    }

    @Override
    boolean shouldSourceDestroy(DamageSource var0) {
        return EntityMinecartTNT.damageSourceIgnitesTnt(var0);
    }

    private static boolean damageSourceIgnitesTnt(DamageSource var0) {
        return var0.is(DamageTypeTags.IS_FIRE) || var0.is(DamageTypeTags.IS_EXPLOSION);
    }
}

