/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityThrownTrident
extends EntityArrow {
    private static final DataWatcherObject<Byte> ID_LOYALTY = DataWatcher.defineId(EntityThrownTrident.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Boolean> ID_FOIL = DataWatcher.defineId(EntityThrownTrident.class, DataWatcherRegistry.BOOLEAN);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public EntityThrownTrident(EntityTypes<? extends EntityThrownTrident> var0, World var1) {
        super((EntityTypes<? extends EntityArrow>)var0, var1);
    }

    public EntityThrownTrident(World var0, EntityLiving var1, ItemStack var2) {
        super(EntityTypes.TRIDENT, var1, var0, var2, null);
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(var2));
        this.entityData.set(ID_FOIL, var2.hasFoil());
    }

    public EntityThrownTrident(World var0, double var1, double var3, double var5, ItemStack var7) {
        super(EntityTypes.TRIDENT, var1, var3, var5, var0, var7, var7);
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(var7));
        this.entityData.set(ID_FOIL, var7.hasFoil());
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(ID_LOYALTY, (byte)0);
        var0.define(ID_FOIL, false);
    }

    @Override
    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity var0 = this.getOwner();
        byte var1 = this.entityData.get(ID_LOYALTY);
        if (var1 > 0 && (this.dealtDamage || this.isNoPhysics()) && var0 != null) {
            if (!this.isAcceptibleReturnOwner()) {
                World world = this.level();
                if (world instanceof WorldServer) {
                    WorldServer var2 = (WorldServer)world;
                    if (this.pickup == EntityArrow.PickupStatus.ALLOWED) {
                        this.spawnAtLocation(var2, this.getPickupItem(), 0.1f);
                    }
                }
                this.discard();
            } else {
                if (!(var0 instanceof EntityHuman) && this.position().distanceTo(var0.getEyePosition()) < (double)var0.getBbWidth() + 1.0) {
                    this.discard();
                    return;
                }
                this.setNoPhysics(true);
                Vec3D var2 = var0.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + var2.y * 0.015 * (double)var1, this.getZ());
                double var3 = 0.05 * (double)var1;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(var2.normalize().scale(var3)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEffects.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity var0 = this.getOwner();
        if (var0 == null || !var0.isAlive()) {
            return false;
        }
        return !(var0 instanceof EntityPlayer) || !var0.isSpectator();
    }

    public boolean isFoil() {
        return this.entityData.get(ID_FOIL);
    }

    @Override
    @Nullable
    protected MovingObjectPositionEntity findHitEntity(Vec3D var0, Vec3D var1) {
        if (this.dealtDamage) {
            return null;
        }
        return super.findHitEntity(var0, var1);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        Object var5;
        Entity var1 = var0.getEntity();
        float var2 = 8.0f;
        Entity var3 = this.getOwner();
        DamageSource var4 = this.damageSources().trident(this, var3 == null ? this : var3);
        World world = this.level();
        if (world instanceof WorldServer) {
            var5 = (WorldServer)world;
            var2 = EnchantmentManager.modifyDamage((WorldServer)var5, this.getWeaponItem(), var1, var4, var2);
        }
        this.dealtDamage = true;
        if (var1.hurtOrSimulate(var4, var2)) {
            if (var1.getType() == EntityTypes.ENDERMAN) {
                return;
            }
            world = this.level();
            if (world instanceof WorldServer) {
                var5 = (WorldServer)world;
                EnchantmentManager.doPostAttackEffectsWithItemSourceOnBreak((WorldServer)var5, var1, var4, this.getWeaponItem(), arg_0 -> this.b((WorldServer)var5, arg_0));
            }
            if (var1 instanceof EntityLiving) {
                var5 = (EntityLiving)var1;
                this.doKnockback((EntityLiving)var5, var4);
                this.doPostHurtEffects((EntityLiving)var5);
            }
        }
        this.deflect(ProjectileDeflection.REVERSE, var1, this.getOwner(), false);
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.02, 0.2, 0.02));
        this.playSound(SoundEffects.TRIDENT_HIT, 1.0f, 1.0f);
    }

    @Override
    protected void hitBlockEnchantmentEffects(WorldServer var0, MovingObjectPositionBlock var12, ItemStack var2) {
        EntityLiving var4;
        Vec3D var3 = var12.getBlockPos().clampLocationWithin(var12.getLocation());
        Entity entity = this.getOwner();
        EnchantmentManager.onHitBlock(var0, var2, entity instanceof EntityLiving ? (var4 = (EntityLiving)entity) : null, this, null, var3, var0.getBlockState(var12.getBlockPos()), var1 -> this.kill(var0));
    }

    @Override
    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    @Override
    protected boolean tryPickup(EntityHuman var0) {
        return super.tryPickup(var0) || this.isNoPhysics() && this.ownedBy(var0) && var0.getInventory().add(this.getPickupItem());
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.TRIDENT);
    }

    @Override
    protected SoundEffect getDefaultHitGroundSoundEvent() {
        return SoundEffects.TRIDENT_HIT_GROUND;
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.ownedBy(var0) || this.getOwner() == null) {
            super.playerTouch(var0);
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.dealtDamage = var0.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(this.getPickupItemStackOrigin()));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("DealtDamage", this.dealtDamage);
    }

    private byte getLoyaltyFromItem(ItemStack var0) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            return (byte)MathHelper.clamp(EnchantmentManager.getTridentReturnToOwnerAcceleration(var1, var0, this), 0, 127);
        }
        return 0;
    }

    @Override
    public void tickDespawn() {
        byte var0 = this.entityData.get(ID_LOYALTY);
        if (this.pickup != EntityArrow.PickupStatus.ALLOWED || var0 <= 0) {
            super.tickDespawn();
        }
    }

    @Override
    protected float getWaterInertia() {
        return 0.99f;
    }

    @Override
    public boolean shouldRender(double var0, double var2, double var4) {
        return true;
    }

    private /* synthetic */ void b(WorldServer var0, Item var1) {
        this.kill(var0);
    }
}

