/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityPiglin.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_IS_CHARGING_CROSSBOW = DataWatcher.defineId(EntityPiglin.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_IS_DANCING = DataWatcher.defineId(EntityPiglin.class, DataWatcherRegistry.BOOLEAN);
    private static final MinecraftKey SPEED_MODIFIER_BABY_ID = MinecraftKey.withDefaultNamespace("baby");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_ID, 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final int MAX_HEALTH = 16;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.35f;
    private static final int ATTACK_DAMAGE = 5;
    private static final float CHANCE_OF_WEARING_EACH_ARMOUR_ITEM = 0.1f;
    private static final int MAX_PASSENGERS_ON_ONE_HOGLIN = 3;
    private static final float PROBABILITY_OF_SPAWNING_AS_BABY = 0.2f;
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.PIGLIN.getDimensions().scale(0.5f).withEyeHeight(0.97f);
    private static final double PROBABILITY_OF_SPAWNING_WITH_CROSSBOW_INSTEAD_OF_SWORD = 0.5;
    public final InventorySubcontainer inventory = new InventorySubcontainer(8);
    public boolean cannotHunt;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ITEMS, SensorType.HURT_BY, SensorType.PIGLIN_SPECIFIC_SENSOR);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, MemoryModuleType.NEARBY_ADULT_PIGLINS, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, (Object[])new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.PATH, MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.ADMIRING_ITEM, MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, MemoryModuleType.ADMIRING_DISABLED, MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, MemoryModuleType.CELEBRATE_LOCATION, MemoryModuleType.DANCING, MemoryModuleType.HUNTED_RECENTLY, MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.RIDE_TARGET, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.NEAREST_REPELLENT});

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> var0, World var1) {
        super(var0, var1);
        this.xpReward = 5;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.isBaby()) {
            var0.putBoolean("IsBaby", true);
        }
        if (this.cannotHunt) {
            var0.putBoolean("CannotHunt", true);
        }
        this.writeInventoryToTag(var0, this.registryAccess());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setBaby(var0.getBoolean("IsBaby"));
        this.setCannotHunt(var0.getBoolean("CannotHunt"));
        this.readInventoryFromTag(var0, this.registryAccess());
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer getInventory() {
        return this.inventory;
    }

    @Override
    protected void dropCustomDeathLoot(WorldServer var0, DamageSource var12, boolean var2) {
        EntityCreeper var4;
        super.dropCustomDeathLoot(var0, var12, var2);
        Entity var3 = var12.getEntity();
        if (var3 instanceof EntityCreeper && (var4 = (EntityCreeper)var3).canDropMobsSkull()) {
            ItemStack var5 = new ItemStack(Items.PIGLIN_HEAD);
            var4.increaseDroppedSkulls();
            this.spawnAtLocation(var0, var5);
        }
        this.inventory.removeAllItems().forEach(var1 -> this.spawnAtLocation(var0, (ItemStack)var1));
    }

    protected ItemStack addToInventory(ItemStack var0) {
        return this.inventory.addItem(var0);
    }

    protected boolean canAddToInventory(ItemStack var0) {
        return this.inventory.canAddItem(var0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_BABY_ID, false);
        var0.define(DATA_IS_CHARGING_CROSSBOW, false);
        var0.define(DATA_IS_DANCING, false);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_BABY_ID.equals(var0)) {
            this.refreshDimensions();
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 16.0).add(GenericAttributes.MOVEMENT_SPEED, 0.35f).add(GenericAttributes.ATTACK_DAMAGE, 5.0);
    }

    public static boolean checkPiglinSpawnRules(EntityTypes<EntityPiglin> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return !var1.getBlockState(var3.below()).is(Blocks.NETHER_WART_BLOCK);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        RandomSource var4 = var0.getRandom();
        if (var2 != EntitySpawnReason.STRUCTURE) {
            if (var4.nextFloat() < 0.2f) {
                this.setBaby(true);
            } else if (this.isAdult()) {
                this.setItemSlot(EnumItemSlot.MAINHAND, this.createSpawnWeapon());
            }
        }
        PiglinAI.initMemories(this, var0.getRandom());
        this.populateDefaultEquipmentSlots(var4, var1);
        this.populateDefaultEquipmentEnchantments(var0, var4, var1);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.isPersistenceRequired();
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        if (this.isAdult()) {
            this.maybeWearArmor(EnumItemSlot.HEAD, new ItemStack(Items.GOLDEN_HELMET), var0);
            this.maybeWearArmor(EnumItemSlot.CHEST, new ItemStack(Items.GOLDEN_CHESTPLATE), var0);
            this.maybeWearArmor(EnumItemSlot.LEGS, new ItemStack(Items.GOLDEN_LEGGINGS), var0);
            this.maybeWearArmor(EnumItemSlot.FEET, new ItemStack(Items.GOLDEN_BOOTS), var0);
        }
    }

    private void maybeWearArmor(EnumItemSlot var0, ItemStack var1, RandomSource var2) {
        if (var2.nextFloat() < 0.1f) {
            this.setItemSlot(var0, var1);
        }
    }

    protected BehaviorController.b<EntityPiglin> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return PiglinAI.makeBrain(this, this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<EntityPiglin> getBrain() {
        return super.getBrain();
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        EnumInteractionResult var2 = super.mobInteract(var0, var1);
        if (var2.consumesAction()) {
            return var2;
        }
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var3 = (WorldServer)world;
            return PiglinAI.mobInteract(var3, this, var0, var1);
        }
        boolean var3 = PiglinAI.canAdmire(this, var0.getItemInHand(var1)) && this.getArmPose() != EntityPiglinArmPose.ADMIRING_ITEM;
        return var3 ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    @Override
    public void setBaby(boolean var0) {
        this.getEntityData().set(DATA_BABY_ID, var0);
        if (!this.level().isClientSide) {
            AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            var1.removeModifier(SPEED_MODIFIER_BABY.id());
            if (var0) {
                var1.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    @Override
    public boolean isBaby() {
        return this.getEntityData().get(DATA_BABY_ID);
    }

    private void setCannotHunt(boolean var0) {
        this.cannotHunt = var0;
    }

    @Override
    protected boolean canHunt() {
        return !this.cannotHunt;
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("piglinBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        PiglinAI.updateActivity(this);
        super.customServerAiStep(var0);
    }

    @Override
    protected int getBaseExperienceReward(WorldServer var0) {
        return this.xpReward;
    }

    @Override
    protected void finishConversion(WorldServer var0) {
        PiglinAI.cancelAdmiring(var0, this);
        this.inventory.removeAllItems().forEach(var1 -> this.spawnAtLocation(var0, (ItemStack)var1));
        super.finishConversion(var0);
    }

    private ItemStack createSpawnWeapon() {
        if ((double)this.random.nextFloat() < 0.5) {
            return new ItemStack(Items.CROSSBOW);
        }
        return new ItemStack(Items.GOLDEN_SWORD);
    }

    private boolean isChargingCrossbow() {
        return this.entityData.get(DATA_IS_CHARGING_CROSSBOW);
    }

    @Override
    public void setChargingCrossbow(boolean var0) {
        this.entityData.set(DATA_IS_CHARGING_CROSSBOW, var0);
    }

    @Override
    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    @Override
    public EntityPiglinArmPose getArmPose() {
        if (this.isDancing()) {
            return EntityPiglinArmPose.DANCING;
        }
        if (PiglinAI.isLovedItem(this.getOffhandItem())) {
            return EntityPiglinArmPose.ADMIRING_ITEM;
        }
        if (this.isAggressive() && this.isHoldingMeleeWeapon()) {
            return EntityPiglinArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.isChargingCrossbow()) {
            return EntityPiglinArmPose.CROSSBOW_CHARGE;
        }
        if (this.isHolding(Items.CROSSBOW) && ItemCrossbow.isCharged(this.getWeaponItem())) {
            return EntityPiglinArmPose.CROSSBOW_HOLD;
        }
        return EntityPiglinArmPose.DEFAULT;
    }

    public boolean isDancing() {
        return this.entityData.get(DATA_IS_DANCING);
    }

    public void setDancing(boolean var0) {
        this.entityData.set(DATA_IS_DANCING, var0);
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        Entity entity;
        boolean var3 = super.hurtServer(var0, var1, var2);
        if (var3 && (entity = var1.getEntity()) instanceof EntityLiving) {
            EntityLiving var4 = (EntityLiving)entity;
            PiglinAI.wasHurtBy(var0, this, var4);
        }
        return var3;
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        this.performCrossbowAttack(this, 1.6f);
    }

    @Override
    public boolean canFireProjectileWeapon(ItemProjectileWeapon var0) {
        return var0 == Items.CROSSBOW;
    }

    protected void holdInMainHand(ItemStack var0) {
        this.setItemSlotAndDropWhenKilled(EnumItemSlot.MAINHAND, var0);
    }

    protected void holdInOffHand(ItemStack var0) {
        if (var0.is(PiglinAI.BARTERING_ITEM)) {
            this.setItemSlot(EnumItemSlot.OFFHAND, var0);
            this.setGuaranteedDrop(EnumItemSlot.OFFHAND);
        } else {
            this.setItemSlotAndDropWhenKilled(EnumItemSlot.OFFHAND, var0);
        }
    }

    @Override
    public boolean wantsToPickUp(WorldServer var0, ItemStack var1) {
        return var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && this.canPickUpLoot() && PiglinAI.wantsToPickup(this, var1);
    }

    protected boolean canReplaceCurrentItem(ItemStack var0) {
        EnumItemSlot var1 = this.getEquipmentSlotForItem(var0);
        ItemStack var2 = this.getItemBySlot(var1);
        return this.canReplaceCurrentItem(var0, var2, var1);
    }

    @Override
    protected boolean canReplaceCurrentItem(ItemStack var0, ItemStack var1, EnumItemSlot var2) {
        boolean var4;
        if (EnchantmentManager.has(var1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            return false;
        }
        boolean var3 = PiglinAI.isLovedItem(var0) || var0.is(Items.CROSSBOW);
        boolean bl = var4 = PiglinAI.isLovedItem(var1) || var1.is(Items.CROSSBOW);
        if (var3 && !var4) {
            return true;
        }
        if (!var3 && var4) {
            return false;
        }
        if (this.isAdult() && !var0.is(Items.CROSSBOW) && var1.is(Items.CROSSBOW)) {
            return false;
        }
        return super.canReplaceCurrentItem(var0, var1, var2);
    }

    @Override
    protected void pickUpItem(WorldServer var0, EntityItem var1) {
        this.onItemPickup(var1);
        PiglinAI.pickUpItem(var0, this, var1);
    }

    @Override
    public boolean startRiding(Entity var0, boolean var1) {
        if (this.isBaby() && var0.getType() == EntityTypes.HOGLIN) {
            var0 = this.getTopPassenger(var0, 3);
        }
        return super.startRiding(var0, var1);
    }

    private Entity getTopPassenger(Entity var0, int var1) {
        List<Entity> var2 = var0.getPassengers();
        if (var1 == 1 || var2.isEmpty()) {
            return var0;
        }
        return this.getTopPassenger(var2.get(0), var1 - 1);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.level().isClientSide) {
            return null;
        }
        return PiglinAI.getSoundForCurrentActivity(this).orElse(null);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PIGLIN_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PIGLIN_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.PIGLIN_STEP, 0.15f, 1.0f);
    }

    @Override
    protected void playConvertedSound() {
        this.makeSound(SoundEffects.PIGLIN_CONVERTED_TO_ZOMBIFIED);
    }
}

