/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class CreakingTransient
extends Creaking {
    public static final int INVULNERABILITY_ANIMATION_DURATION = 8;
    private int invulnerabilityAnimationRemainingTicks;
    @Nullable
    BlockPosition homePos;

    public CreakingTransient(EntityTypes<? extends Creaking> var0, World var1) {
        super(var0, var1);
    }

    public void bindToCreakingHeart(BlockPosition var0) {
        this.homePos = var0;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        CreakingHeartBlockEntity var3;
        if (this.level().isClientSide) {
            return super.hurtServer(var0, var1, var2);
        }
        if (var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurtServer(var0, var1, var2);
        }
        if (this.isInvulnerableTo(var0, var1) || this.invulnerabilityAnimationRemainingTicks > 0) {
            return false;
        }
        this.invulnerabilityAnimationRemainingTicks = 8;
        this.level().broadcastEntityEvent(this, (byte)66);
        TileEntity tileEntity = this.level().getBlockEntity(this.homePos);
        if (tileEntity instanceof CreakingHeartBlockEntity && (var3 = (CreakingHeartBlockEntity)tileEntity).isProtector(this)) {
            if (var1.getEntity() instanceof EntityHuman) {
                var3.creakingHurt();
            }
            this.playHurtSound(var1);
        }
        return true;
    }

    @Override
    public void aiStep() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            --this.invulnerabilityAnimationRemainingTicks;
        }
        super.aiStep();
    }

    @Override
    public void tick() {
        CreakingHeartBlockEntity var0;
        TileEntity tileEntity;
        if (!(this.level().isClientSide || this.homePos != null && (tileEntity = this.level().getBlockEntity(this.homePos)) instanceof CreakingHeartBlockEntity && (var0 = (CreakingHeartBlockEntity)tileEntity).isProtector(this))) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 66) {
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.playHurtSound(this.damageSources().generic());
        } else {
            super.handleEntityEvent(var0);
        }
    }

    private void setupAnimationStates() {
        this.invulnerabilityAnimationState.animateWhen(this.invulnerabilityAnimationRemainingTicks > 0, this.tickCount);
    }

    public void tearDown(@Nullable DamageSource var0) {
        Object var1;
        Object object = this.level();
        if (object instanceof WorldServer) {
            var1 = (WorldServer)object;
            AxisAlignedBB var2 = this.getBoundingBox();
            Vec3D var3 = var2.getCenter();
            double var4 = var2.getXsize() * 0.3;
            double var6 = var2.getYsize() * 0.3;
            double var8 = var2.getZsize() * 0.3;
            ((WorldServer)var1).sendParticles(new ParticleParamBlock(Particles.BLOCK_CRUMBLE, Blocks.PALE_OAK_WOOD.defaultBlockState()), var3.x, var3.y, var3.z, 100, var4, var6, var8, 0.0);
            ((WorldServer)var1).sendParticles(new ParticleParamBlock(Particles.BLOCK_CRUMBLE, (IBlockData)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.a.ACTIVE)), var3.x, var3.y, var3.z, 10, var4, var6, var8, 0.0);
        }
        this.makeSound(this.getDeathSound());
        if (this.deathScore >= 0 && var0 != null && (object = var0.getEntity()) instanceof EntityLiving) {
            var1 = (EntityLiving)object;
            ((Entity)var1).awardKillScore(this, this.deathScore, var0);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return false;
    }

    @Override
    protected boolean couldAcceptPassenger() {
        return false;
    }

    @Override
    protected void addPassenger(Entity var0) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    @Override
    public boolean canUsePortal(boolean var0) {
        return false;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new a(this, var0);
    }

    class a
    extends Navigation {
        a(Creaking var1, World var2) {
            super(var1, var2);
        }

        @Override
        public void tick() {
            if (CreakingTransient.this.canMove()) {
                super.tick();
            }
        }

        @Override
        protected Pathfinder createPathFinder(int var0) {
            this.nodeEvaluator = new b();
            return new Pathfinder(this.nodeEvaluator, var0);
        }
    }

    class b
    extends PathfinderNormal {
        private static final int MAX_DISTANCE_TO_HOME_SQ = 1024;

        b() {
        }

        @Override
        public PathType getPathType(PathfindingContext var0, int var1, int var2, int var3) {
            BlockPosition var4 = CreakingTransient.this.homePos;
            if (var4 == null) {
                return super.getPathType(var0, var1, var2, var3);
            }
            double var5 = var4.distSqr(new BaseBlockPosition(var1, var2, var3));
            if (var5 > 1024.0 && var5 >= var4.distSqr(var0.mobPosition())) {
                return PathType.BLOCKED;
            }
            return super.getPathType(var0, var1, var2, var3);
        }
    }
}

