/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.creaking.CreakingAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class Creaking
extends EntityMonster {
    private static final DataWatcherObject<Boolean> CAN_MOVE = DataWatcher.defineId(Creaking.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> IS_ACTIVE = DataWatcher.defineId(Creaking.class, DataWatcherRegistry.BOOLEAN);
    private static final int ATTACK_ANIMATION_DURATION = 20;
    private static final int MAX_HEALTH = 1;
    private static final float ATTACK_DAMAGE = 2.0f;
    private static final float FOLLOW_RANGE = 32.0f;
    private static final float ACTIVATION_RANGE_SQ = 144.0f;
    public static final int ATTACK_INTERVAL = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    public static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.2f;
    public static final int CREAKING_ORANGE = 16545810;
    public static final int CREAKING_GRAY = 0x5F5F5F;
    private int attackAnimationRemainingTicks;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState invulnerabilityAnimationState = new AnimationState();

    public Creaking(EntityTypes<? extends Creaking> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.lookControl = new c(this);
        this.moveControl = new d(this);
        this.jumpControl = new b(this);
        Navigation var2 = (Navigation)this.getNavigation();
        var2.setCanFloat(true);
        this.xpReward = 0;
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new a(this);
    }

    protected BehaviorController.b<Creaking> brainProvider() {
        return CreakingAi.brainProvider();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return CreakingAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(CAN_MOVE, true);
        var0.define(IS_ACTIVE, false);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 1.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.ATTACK_DAMAGE, 2.0).add(GenericAttributes.FOLLOW_RANGE, 32.0).add(GenericAttributes.STEP_HEIGHT, 1.0);
    }

    public boolean canMove() {
        return this.entityData.get(CAN_MOVE);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        if (!(var1 instanceof EntityLiving)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 20;
        this.level().broadcastEntityEvent(this, (byte)4);
        return super.doHurtTarget(var0, var1);
    }

    @Override
    public boolean isPushable() {
        return super.isPushable() && this.canMove();
    }

    public BehaviorController<Creaking> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("creakingBrain");
        this.getBrain().tick((WorldServer)this.level(), this);
        var1.pop();
        CreakingAi.updateActivity(this);
    }

    @Override
    public void aiStep() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        if (!this.level().isClientSide) {
            boolean var0 = this.entityData.get(CAN_MOVE);
            boolean var1 = this.checkCanMove();
            if (var1 != var0) {
                this.gameEvent(GameEvent.ENTITY_ACTION);
                if (var1) {
                    this.makeSound(SoundEffects.CREAKING_UNFREEZE);
                } else {
                    this.stopInPlace();
                    this.makeSound(SoundEffects.CREAKING_FREEZE);
                }
            }
            this.entityData.set(CAN_MOVE, var1);
        }
        super.aiStep();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.attackAnimationState.animateWhen(this.attackAnimationRemainingTicks > 0, this.tickCount);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 4) {
            this.attackAnimationRemainingTicks = 20;
            this.playAttackSound();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public void playAttackSound() {
        this.makeSound(SoundEffects.CREAKING_ATTACK);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isActive()) {
            return null;
        }
        return SoundEffects.CREAKING_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CREAKING_SWAY;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CREAKING_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.CREAKING_STEP, 0.15f, 1.0f);
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.getTargetFromBrain();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public void knockback(double var0, double var2, double var4) {
        if (!this.canMove()) {
            return;
        }
        super.knockback(var0, var2, var4);
    }

    public boolean checkCanMove() {
        List var02 = this.brain.getMemory(MemoryModuleType.NEAREST_PLAYERS).orElse(List.of());
        if (var02.isEmpty()) {
            if (this.isActive()) {
                this.gameEvent(GameEvent.ENTITY_ACTION);
                this.makeSound(SoundEffects.CREAKING_DEACTIVATE);
                this.setIsActive(false);
            }
            return true;
        }
        Predicate<EntityLiving> var1 = this.isActive() ? EntityLiving.PLAYER_NOT_WEARING_DISGUISE_ITEM : var0 -> true;
        for (EntityHuman var3 : var02) {
            if (var3.isCreative() || !this.isLookingAtMe(var3, 0.5, false, true, var1, this::getEyeY, this::getY, () -> (this.getEyeY() + this.getY()) / 2.0)) continue;
            if (this.isActive()) {
                return false;
            }
            if (!(var3.distanceToSqr(this) < 144.0)) continue;
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.makeSound(SoundEffects.CREAKING_ACTIVATE);
            this.setIsActive(true);
            this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, var3);
            return false;
        }
        return true;
    }

    public void setIsActive(boolean var0) {
        this.entityData.set(IS_ACTIVE, var0);
    }

    public boolean isActive() {
        return this.entityData.get(IS_ACTIVE);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    class c
    extends ControllerLook {
        public c(Creaking var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            }
        }
    }

    class d
    extends ControllerMove {
        public d(Creaking var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            }
        }
    }

    class b
    extends ControllerJump {
        public b(Creaking var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (Creaking.this.canMove()) {
                super.tick();
            } else {
                Creaking.this.setJumping(false);
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Creaking var1) {
            super(var1);
        }

        @Override
        public void clientTick() {
            if (Creaking.this.canMove()) {
                super.clientTick();
            }
        }
    }
}

