/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.breeze.LongJump;
import net.minecraft.world.entity.monster.breeze.Shoot;
import net.minecraft.world.entity.monster.breeze.ShootWhenStuck;
import net.minecraft.world.entity.monster.breeze.Slide;
import net.minecraft.world.entity.schedule.Activity;

public class BreezeAi {
    public static final float SPEED_MULTIPLIER_WHEN_SLIDING = 0.6f;
    public static final float JUMP_CIRCLE_INNER_RADIUS = 4.0f;
    public static final float JUMP_CIRCLE_MIDDLE_RADIUS = 8.0f;
    public static final float JUMP_CIRCLE_OUTER_RADIUS = 24.0f;
    static final List<SensorType<? extends Sensor<? super Breeze>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.HURT_BY, SensorType.NEAREST_PLAYERS, SensorType.BREEZE_ATTACK_ENTITY_SENSOR);
    static final List<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.BREEZE_JUMP_COOLDOWN, MemoryModuleType.BREEZE_JUMP_INHALING, MemoryModuleType.BREEZE_SHOOT, MemoryModuleType.BREEZE_SHOOT_CHARGING, MemoryModuleType.BREEZE_SHOOT_RECOVERING, MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object[])new MemoryModuleType[]{MemoryModuleType.BREEZE_JUMP_TARGET, MemoryModuleType.BREEZE_LEAVING_WATER, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.PATH});
    private static final int TICKS_TO_REMEMBER_SEEN_TARGET = 100;

    protected static BehaviorController<?> makeBrain(Breeze var0, BehaviorController<Breeze> var1) {
        BreezeAi.initCoreActivity(var1);
        BreezeAi.initIdleActivity(var1);
        BreezeAi.initFightActivity(var0, var1);
        var1.setCoreActivities(Set.of(Activity.CORE));
        var1.setDefaultActivity(Activity.FIGHT);
        var1.useDefaultActivity();
        return var1;
    }

    private static void initCoreActivity(BehaviorController<Breeze> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Breeze>>)ImmutableList.of(new BehaviorSwim(0.8f), (Object)new BehaviorLook(45, 90)));
    }

    private static void initIdleActivity(BehaviorController<Breeze> var02) {
        var02.addActivity(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<Breeze>>>)ImmutableList.of((Object)Pair.of((Object)0, BehaviorAttackTargetSet.create((var0, var1) -> var1.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)1, BehaviorAttackTargetSet.create((var0, var1) -> var1.getHurtBy())), (Object)Pair.of((Object)2, (Object)new a(20, 40)), (Object)Pair.of((Object)3, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new BehaviorNop(20, 100), (Object)1), (Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.6f), (Object)2))))));
    }

    private static void initFightActivity(Breeze var0, BehaviorController<Breeze> var1) {
        var1.addActivityWithConditions(Activity.FIGHT, (ImmutableList<Pair<Integer, BehaviorControl<Breeze>>>)ImmutableList.of((Object)Pair.of((Object)0, BehaviorAttackTargetForget.create(Sensor.wasEntityAttackableLastNTicks(var0, 100).negate()::test)), (Object)Pair.of((Object)1, (Object)new Shoot()), (Object)Pair.of((Object)2, (Object)new LongJump()), (Object)Pair.of((Object)3, (Object)new ShootWhenStuck()), (Object)Pair.of((Object)4, (Object)new Slide())), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), (Object)Pair.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT))));
    }

    static void updateActivity(Breeze var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    public static class a
    extends BehavorMove {
        @VisibleForTesting
        public a(int var0, int var1) {
            super(var0, var1);
        }

        @Override
        protected void start(WorldServer var0, EntityInsentient var1, long var2) {
            super.start(var0, var1, var2);
            var1.playSound(SoundEffects.BREEZE_SLIDE);
            var1.setPose(EntityPose.SLIDING);
        }

        @Override
        protected void stop(WorldServer var0, EntityInsentient var1, long var2) {
            super.stop(var0, var1, var2);
            var1.setPose(EntityPose.STANDING);
            if (var1.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                var1.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT, Unit.INSTANCE, 60L);
            }
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (EntityInsentient)entityLiving, l2);
        }
    }
}

