/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> DATA_CONVERTING_ID = DataWatcher.defineId(EntityZombieVillager.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<VillagerData> DATA_VILLAGER_DATA = DataWatcher.defineId(EntityZombieVillager.class, DataWatcherRegistry.VILLAGER_DATA);
    private static final int VILLAGER_CONVERSION_WAIT_MIN = 3600;
    private static final int VILLAGER_CONVERSION_WAIT_MAX = 6000;
    private static final int MAX_SPECIAL_BLOCKS_COUNT = 14;
    private static final int SPECIAL_BLOCK_RADIUS = 4;
    public int villagerConversionTime;
    @Nullable
    public UUID conversionStarter;
    @Nullable
    private NBTBase gossips;
    @Nullable
    private MerchantRecipeList tradeOffers;
    private int villagerXp;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> var02, World var1) {
        super((EntityTypes<? extends EntityZombie>)var02, var1);
        BuiltInRegistries.VILLAGER_PROFESSION.getRandom(this.random).ifPresent(var0 -> this.setVillagerData(this.getVillagerData().setProfession((VillagerProfession)var0.value())));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_CONVERTING_ID, false);
        var0.define(DATA_VILLAGER_DATA, new VillagerData(VillagerType.PLAINS, VillagerProfession.NONE, 1));
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        VillagerData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.getVillagerData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("VillagerData", (NBTBase)var1));
        if (this.tradeOffers != null) {
            var0.put("Offers", (NBTBase)MerchantRecipeList.CODEC.encodeStart(this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this.tradeOffers).getOrThrow());
        }
        if (this.gossips != null) {
            var0.put("Gossips", this.gossips);
        }
        var0.putInt("ConversionTime", this.isConverting() ? this.villagerConversionTime : -1);
        if (this.conversionStarter != null) {
            var0.putUUID("ConversionPlayer", this.conversionStarter);
        }
        var0.putInt("Xp", this.villagerXp);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        if (var02.contains("VillagerData", 10)) {
            DataResult var1 = VillagerData.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get("VillagerData")));
            var1.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setVillagerData);
        }
        if (var02.contains("Offers")) {
            MerchantRecipeList.CODEC.parse(this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var02.get("Offers")).resultOrPartial(SystemUtils.prefix("Failed to load offers: ", arg_0 -> ((Logger)LOGGER).warn(arg_0))).ifPresent(var0 -> {
                this.tradeOffers = var0;
            });
        }
        if (var02.contains("Gossips", 9)) {
            this.gossips = var02.getList("Gossips", 10);
        }
        if (var02.contains("ConversionTime", 99) && var02.getInt("ConversionTime") > -1) {
            this.startConverting(var02.hasUUID("ConversionPlayer") ? var02.getUUID("ConversionPlayer") : null, var02.getInt("ConversionTime"));
        }
        if (var02.contains("Xp", 3)) {
            this.villagerXp = var02.getInt("Xp");
        }
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && this.isConverting()) {
            int var0 = this.getConversionProgress();
            this.villagerConversionTime -= var0;
            if (this.villagerConversionTime <= 0) {
                this.finishConversion((WorldServer)this.level());
            }
        }
        super.tick();
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.GOLDEN_APPLE)) {
            if (this.hasEffect(MobEffects.WEAKNESS)) {
                var2.consume(1, var0);
                if (!this.level().isClientSide) {
                    this.startConverting(var0.getUUID(), this.random.nextInt(2401) + 3600);
                }
                return EnumInteractionResult.SUCCESS_SERVER;
            }
            return EnumInteractionResult.CONSUME;
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.isConverting() && this.villagerXp == 0;
    }

    public boolean isConverting() {
        return this.getEntityData().get(DATA_CONVERTING_ID);
    }

    public void startConverting(@Nullable UUID var0, int var1) {
        this.conversionStarter = var0;
        this.villagerConversionTime = var1;
        this.getEntityData().set(DATA_CONVERTING_ID, true);
        this.removeEffect(MobEffects.WEAKNESS);
        this.addEffect(new MobEffect(MobEffects.DAMAGE_BOOST, var1, Math.min(this.level().getDifficulty().getId() - 1, 0)));
        this.level().broadcastEntityEvent(this, (byte)16);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 16) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEffects.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            return;
        }
        super.handleEntityEvent(var0);
    }

    private void finishConversion(WorldServer var0) {
        this.convertTo(EntityTypes.VILLAGER, ConversionParams.single(this, false, false), var1 -> {
            EntityHuman var2;
            for (EnumItemSlot var3 : this.dropPreservedEquipment(var0, var0 -> !EnchantmentManager.has(var0, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE))) {
                SlotAccess var4 = var1.getSlot(var3.getIndex() + 300);
                var4.set(this.getItemBySlot(var3));
            }
            var1.setVillagerData(this.getVillagerData());
            if (this.gossips != null) {
                var1.setGossips(this.gossips);
            }
            if (this.tradeOffers != null) {
                var1.setOffers(this.tradeOffers.copy());
            }
            var1.setVillagerXp(this.villagerXp);
            var1.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var1.blockPosition()), EntitySpawnReason.CONVERSION, null);
            var1.refreshBrain(var0);
            if (this.conversionStarter != null && (var2 = var0.getPlayerByUUID(this.conversionStarter)) instanceof EntityPlayer) {
                CriterionTriggers.CURED_ZOMBIE_VILLAGER.trigger((EntityPlayer)var2, this, (EntityVillager)var1);
                var0.onReputationEvent(ReputationEvent.ZOMBIE_VILLAGER_CURED, var2, (ReputationHandler)((Object)var1));
            }
            var1.addEffect(new MobEffect(MobEffects.CONFUSION, 200, 0));
            if (!this.isSilent()) {
                var0.levelEvent(null, 1027, this.blockPosition(), 0);
            }
        });
    }

    @VisibleForTesting
    public void setVillagerConversionTime(int var0) {
        this.villagerConversionTime = var0;
    }

    private int getConversionProgress() {
        int var0 = 1;
        if (this.random.nextFloat() < 0.01f) {
            int var1 = 0;
            BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
            for (int var3 = (int)this.getX() - 4; var3 < (int)this.getX() + 4 && var1 < 14; ++var3) {
                for (int var4 = (int)this.getY() - 4; var4 < (int)this.getY() + 4 && var1 < 14; ++var4) {
                    for (int var5 = (int)this.getZ() - 4; var5 < (int)this.getZ() + 4 && var1 < 14; ++var5) {
                        IBlockData var6 = this.level().getBlockState(var2.set(var3, var4, var5));
                        if (!var6.is(Blocks.IRON_BARS) && !(var6.getBlock() instanceof BlockBed)) continue;
                        if (this.random.nextFloat() < 0.3f) {
                            ++var0;
                        }
                        ++var1;
                    }
                }
            }
        }
        return var0;
    }

    @Override
    public float getVoicePitch() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 2.0f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect getAmbientSound() {
        return SoundEffects.ZOMBIE_VILLAGER_AMBIENT;
    }

    @Override
    public SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ZOMBIE_VILLAGER_HURT;
    }

    @Override
    public SoundEffect getDeathSound() {
        return SoundEffects.ZOMBIE_VILLAGER_DEATH;
    }

    @Override
    public SoundEffect getStepSound() {
        return SoundEffects.ZOMBIE_VILLAGER_STEP;
    }

    @Override
    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }

    public void setTradeOffers(MerchantRecipeList var0) {
        this.tradeOffers = var0;
    }

    public void setGossips(NBTBase var0) {
        this.gossips = var0;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        this.setVillagerData(this.getVillagerData().setType(VillagerType.byBiome(var0.getBiome(this.blockPosition()))));
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public void setVillagerData(VillagerData var0) {
        VillagerData var1 = this.getVillagerData();
        if (var1.getProfession() != var0.getProfession()) {
            this.tradeOffers = null;
        }
        this.entityData.set(DATA_VILLAGER_DATA, var0);
    }

    @Override
    public VillagerData getVillagerData() {
        return this.entityData.get(DATA_VILLAGER_DATA);
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int var0) {
        this.villagerXp = var0;
    }
}

