/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.World;

public class PathfinderGoalHorseTrap
extends PathfinderGoal {
    private final EntityHorseSkeleton horse;

    public PathfinderGoalHorseTrap(EntityHorseSkeleton var0) {
        this.horse = var0;
    }

    @Override
    public boolean canUse() {
        return this.horse.level().hasNearbyAlivePlayer(this.horse.getX(), this.horse.getY(), this.horse.getZ(), 10.0);
    }

    @Override
    public void tick() {
        WorldServer var0 = (WorldServer)this.horse.level();
        DifficultyDamageScaler var1 = var0.getCurrentDifficultyAt(this.horse.blockPosition());
        this.horse.setTrap(false);
        this.horse.setTamed(true);
        this.horse.setAge(0);
        EntityLightning var2 = EntityTypes.LIGHTNING_BOLT.create(var0, EntitySpawnReason.TRIGGERED);
        if (var2 == null) {
            return;
        }
        var2.moveTo(this.horse.getX(), this.horse.getY(), this.horse.getZ());
        var2.setVisualOnly(true);
        var0.addFreshEntity(var2);
        EntitySkeleton var3 = this.createSkeleton(var1, this.horse);
        if (var3 == null) {
            return;
        }
        var3.startRiding(this.horse);
        var0.addFreshEntityWithPassengers(var3);
        for (int var4 = 0; var4 < 3; ++var4) {
            EntitySkeleton var6;
            EntityHorseAbstract var5 = this.createHorse(var1);
            if (var5 == null || (var6 = this.createSkeleton(var1, var5)) == null) continue;
            var6.startRiding(var5);
            var5.push(this.horse.getRandom().triangle(0.0, 1.1485), 0.0, this.horse.getRandom().triangle(0.0, 1.1485));
            var0.addFreshEntityWithPassengers(var5);
        }
    }

    @Nullable
    private EntityHorseAbstract createHorse(DifficultyDamageScaler var0) {
        EntityHorseSkeleton var1 = EntityTypes.SKELETON_HORSE.create((World)this.horse.level(), EntitySpawnReason.TRIGGERED);
        if (var1 != null) {
            var1.finalizeSpawn((WorldServer)this.horse.level(), var0, EntitySpawnReason.TRIGGERED, null);
            var1.setPos(this.horse.getX(), this.horse.getY(), this.horse.getZ());
            var1.invulnerableTime = 60;
            var1.setPersistenceRequired();
            var1.setTamed(true);
            var1.setAge(0);
        }
        return var1;
    }

    @Nullable
    private EntitySkeleton createSkeleton(DifficultyDamageScaler var0, EntityHorseAbstract var1) {
        EntitySkeleton var2 = EntityTypes.SKELETON.create((World)var1.level(), EntitySpawnReason.TRIGGERED);
        if (var2 != null) {
            var2.finalizeSpawn((WorldServer)var1.level(), var0, EntitySpawnReason.TRIGGERED, null);
            var2.setPos(var1.getX(), var1.getY(), var1.getZ());
            var2.invulnerableTime = 60;
            var2.setPersistenceRequired();
            if (var2.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
                var2.setItemSlot(EnumItemSlot.HEAD, new ItemStack(Items.IRON_HELMET));
            }
            this.enchant(var2, EnumItemSlot.MAINHAND, var0);
            this.enchant(var2, EnumItemSlot.HEAD, var0);
        }
        return var2;
    }

    private void enchant(EntitySkeleton var0, EnumItemSlot var1, DifficultyDamageScaler var2) {
        ItemStack var3 = var0.getItemBySlot(var1);
        var3.set(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        EnchantmentManager.enchantItemFromProvider(var3, var0.level().registryAccess(), VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, var2, var0.getRandom());
        var0.setItemSlot(var1, var3);
    }
}

