/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.armadillo;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.armadillo.ArmadilloAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;

public class Armadillo
extends EntityAnimal {
    public static final float BABY_SCALE = 0.6f;
    public static final float MAX_HEAD_ROTATION_EXTENT = 32.5f;
    public static final int SCARE_CHECK_INTERVAL = 80;
    private static final double SCARE_DISTANCE_HORIZONTAL = 7.0;
    private static final double SCARE_DISTANCE_VERTICAL = 2.0;
    private static final DataWatcherObject<a> ARMADILLO_STATE = DataWatcher.defineId(Armadillo.class, DataWatcherRegistry.ARMADILLO_STATE);
    private long inStateTicks = 0L;
    public final AnimationState rollOutAnimationState = new AnimationState();
    public final AnimationState rollUpAnimationState = new AnimationState();
    public final AnimationState peekAnimationState = new AnimationState();
    private int scuteTime;
    private boolean peekReceivedClient = false;

    public Armadillo(EntityTypes<? extends EntityAnimal> var0, World var1) {
        super(var0, var1);
        this.getNavigation().setCanFloat(true);
        this.scuteTime = this.pickNextScuteDropTime();
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.ARMADILLO.create(var0, EntitySpawnReason.BREEDING);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 12.0).add(GenericAttributes.MOVEMENT_SPEED, 0.14);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(ARMADILLO_STATE, a.IDLE);
    }

    public boolean isScared() {
        return this.entityData.get(ARMADILLO_STATE) != a.IDLE;
    }

    public boolean shouldHideInShell() {
        return this.getState().shouldHideInShell(this.inStateTicks);
    }

    public boolean shouldSwitchToScaredState() {
        return this.getState() == a.ROLLING && this.inStateTicks > (long)a.ROLLING.animationDuration();
    }

    public a getState() {
        return this.entityData.get(ARMADILLO_STATE);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    public void switchToState(a var0) {
        this.entityData.set(ARMADILLO_STATE, var0);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (ARMADILLO_STATE.equals(var0)) {
            this.inStateTicks = 0L;
        }
        super.onSyncedDataUpdated(var0);
    }

    protected BehaviorController.b<Armadillo> brainProvider() {
        return ArmadilloAi.brainProvider();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return ArmadilloAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("armadilloBrain");
        this.brain.tick(var0, this);
        var1.pop();
        var1.push("armadilloActivityUpdate");
        ArmadilloAi.updateActivity(this);
        var1.pop();
        if (this.isAlive() && !this.isBaby() && --this.scuteTime <= 0) {
            if (this.dropFromGiftLootTable(var0, LootTables.ARMADILLO_SHED, this::spawnAtLocation)) {
                this.playSound(SoundEffects.ARMADILLO_SCUTE_DROP, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.gameEvent(GameEvent.ENTITY_PLACE);
            }
            this.scuteTime = this.pickNextScuteDropTime();
        }
        super.customServerAiStep(var0);
    }

    private int pickNextScuteDropTime() {
        return this.random.nextInt(20 * TimeRange.SECONDS_PER_MINUTE * 5) + 20 * TimeRange.SECONDS_PER_MINUTE * 5;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.isScared()) {
            this.clampHeadRotationToBody();
        }
        ++this.inStateTicks;
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.6f : 1.0f;
    }

    private void setupAnimationStates() {
        switch (this.getState().ordinal()) {
            case 0: {
                this.rollOutAnimationState.stop();
                this.rollUpAnimationState.stop();
                this.peekAnimationState.stop();
                break;
            }
            case 3: {
                this.rollOutAnimationState.startIfStopped(this.tickCount);
                this.rollUpAnimationState.stop();
                this.peekAnimationState.stop();
                break;
            }
            case 1: {
                this.rollOutAnimationState.stop();
                this.rollUpAnimationState.startIfStopped(this.tickCount);
                this.peekAnimationState.stop();
                break;
            }
            case 2: {
                this.rollOutAnimationState.stop();
                this.rollUpAnimationState.stop();
                if (this.peekReceivedClient) {
                    this.peekAnimationState.stop();
                    this.peekReceivedClient = false;
                }
                if (this.inStateTicks == 0L) {
                    this.peekAnimationState.start(this.tickCount);
                    this.peekAnimationState.fastForward(a.SCARED.animationDuration(), 1.0f);
                    break;
                }
                this.peekAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 64 && this.level().isClientSide) {
            this.peekReceivedClient = true;
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ARMADILLO_PEEK, this.getSoundSource(), 1.0f, 1.0f, false);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.ARMADILLO_FOOD);
    }

    public static boolean checkArmadilloSpawnRules(EntityTypes<Armadillo> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.ARMADILLO_SPAWNABLE_ON) && Armadillo.isBrightEnoughToSpawn(var1, var3);
    }

    public boolean isScaredBy(EntityLiving var0) {
        if (!this.getBoundingBox().inflate(7.0, 2.0, 7.0).intersects(var0.getBoundingBox())) {
            return false;
        }
        if (var0.getType().is(TagsEntity.UNDEAD)) {
            return true;
        }
        if (this.getLastHurtByMob() == var0) {
            return true;
        }
        if (var0 instanceof EntityHuman) {
            EntityHuman var1 = (EntityHuman)var0;
            if (var1.isSpectator()) {
                return false;
            }
            return var1.isSprinting() || var1.isPassenger();
        }
        return false;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putString("state", this.getState().getSerializedName());
        var0.putInt("scute_time", this.scuteTime);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.switchToState(a.fromName(var0.getString("state")));
        if (var0.contains("scute_time")) {
            this.scuteTime = var0.getInt("scute_time");
        }
    }

    public void rollUp() {
        if (this.isScared()) {
            return;
        }
        this.stopInPlace();
        this.resetLove();
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.makeSound(SoundEffects.ARMADILLO_ROLL);
        this.switchToState(a.ROLLING);
    }

    public void rollOut() {
        if (!this.isScared()) {
            return;
        }
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.makeSound(SoundEffects.ARMADILLO_UNROLL_FINISH);
        this.switchToState(a.IDLE);
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isScared()) {
            var2 = (var2 - 1.0f) / 2.0f;
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    protected void actuallyHurt(WorldServer var0, DamageSource var1, float var2) {
        super.actuallyHurt(var0, var1, var2);
        if (this.isNoAi() || this.isDeadOrDying()) {
            return;
        }
        if (var1.getEntity() instanceof EntityLiving) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY, true, 80L);
            if (this.canStayRolledUp()) {
                this.rollUp();
            }
        } else if (var1.is(DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES)) {
            this.rollOut();
        }
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(Items.BRUSH) && this.brushOffScute()) {
            var2.hurtAndBreak(16, var0, Armadillo.getSlotForHand(var1));
            return EnumInteractionResult.SUCCESS;
        }
        if (this.isScared()) {
            return EnumInteractionResult.FAIL;
        }
        return super.mobInteract(var0, var1);
    }

    public boolean brushOffScute() {
        if (this.isBaby()) {
            return false;
        }
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            this.spawnAtLocation(var0, new ItemStack(Items.ARMADILLO_SCUTE));
            this.gameEvent(GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEffects.ARMADILLO_BRUSH);
        }
        return true;
    }

    public boolean canStayRolledUp() {
        return !this.isPanicking() && !this.isInLiquid() && !this.isLeashed() && !this.isPassenger() && !this.isVehicle();
    }

    @Override
    public boolean canFallInLove() {
        return super.canFallInLove() && !this.isScared();
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isScared()) {
            return null;
        }
        return SoundEffects.ARMADILLO_AMBIENT;
    }

    @Override
    protected void playEatingSound() {
        this.makeSound(SoundEffects.ARMADILLO_EAT);
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ARMADILLO_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isScared()) {
            return SoundEffects.ARMADILLO_HURT_REDUCED;
        }
        return SoundEffects.ARMADILLO_HURT;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.ARMADILLO_STEP, 0.15f, 1.0f);
    }

    @Override
    public int getMaxHeadYRot() {
        if (this.isScared()) {
            return 0;
        }
        return 32;
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new EntityAIBodyControl(this){

            @Override
            public void clientTick() {
                if (!Armadillo.this.isScared()) {
                    super.clientTick();
                }
            }
        };
    }

    public static abstract sealed class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a IDLE = new a("idle", false, 0, 0){

            @Override
            public boolean shouldHideInShell(long var0) {
                return false;
            }
        };
        public static final /* enum */ a ROLLING = new a("rolling", true, 10, 1){

            @Override
            public boolean shouldHideInShell(long var0) {
                return var0 > 5L;
            }
        };
        public static final /* enum */ a SCARED = new a("scared", true, 50, 2){

            @Override
            public boolean shouldHideInShell(long var0) {
                return true;
            }
        };
        public static final /* enum */ a UNROLLING = new a("unrolling", true, 30, 3){

            @Override
            public boolean shouldHideInShell(long var0) {
                return var0 < 26L;
            }
        };
        private static final INamable.a<a> CODEC;
        private static final IntFunction<a> BY_ID;
        public static final StreamCodec<ByteBuf, a> STREAM_CODEC;
        private final String name;
        private final boolean isThreatened;
        private final int animationDuration;
        private final int id;
        private static final /* synthetic */ a[] l;

        public static a[] values() {
            return (a[])l.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        a(String var2, boolean var3, int var4, int var5) {
            this.name = var2;
            this.isThreatened = var3;
            this.animationDuration = var4;
            this.id = var5;
        }

        public static a fromName(String var0) {
            return CODEC.byName(var0, IDLE);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private int id() {
            return this.id;
        }

        public abstract boolean shouldHideInShell(long var1);

        public boolean isThreatened() {
            return this.isThreatened;
        }

        public int animationDuration() {
            return this.animationDuration;
        }

        private static /* synthetic */ a[] e() {
            return new a[]{IDLE, ROLLING, SCARED, UNROLLING};
        }

        static {
            l = a.e();
            CODEC = INamable.fromEnum(a::values);
            BY_ID = ByIdMap.continuous(a::id, a.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, a::id);
        }
    }
}

