/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.allay;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Allay
extends EntityCreature
implements InventoryCarrier,
VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BaseBlockPosition ITEM_PICKUP_REACH = new BaseBlockPosition(1, 1, 1);
    private static final int LIFTING_ITEM_ANIMATION_DURATION = 5;
    private static final float DANCING_LOOP_DURATION = 55.0f;
    private static final float SPINNING_ANIMATION_DURATION = 15.0f;
    private static final int DUPLICATION_COOLDOWN_TICKS = 6000;
    private static final int NUM_OF_DUPLICATION_HEARTS = 3;
    public static final int MAX_NOTEBLOCK_DISTANCE = 1024;
    private static final DataWatcherObject<Boolean> DATA_DANCING = DataWatcher.defineId(Allay.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_CAN_DUPLICATE = DataWatcher.defineId(Allay.class, DataWatcherRegistry.BOOLEAN);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Allay>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.HURT_BY, SensorType.NEAREST_ITEMS);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.PATH, MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.HURT_BY, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.LIKED_PLAYER, MemoryModuleType.LIKED_NOTEBLOCK_POSITION, MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryModuleType.IS_PANICKING, (Object[])new MemoryModuleType[0]);
    public static final ImmutableList<Float> THROW_SOUND_PITCHES = ImmutableList.of((Object)Float.valueOf(0.5625f), (Object)Float.valueOf(0.625f), (Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.9375f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.125f), (Object)Float.valueOf(1.25f), (Object)Float.valueOf(1.5f), (Object)Float.valueOf(1.875f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(2.25f), (Object[])new Float[]{Float.valueOf(2.5f), Float.valueOf(3.0f), Float.valueOf(3.75f), Float.valueOf(4.0f)});
    private final DynamicGameEventListener<VibrationSystem.b> dynamicVibrationListener;
    private VibrationSystem.a vibrationData;
    private final VibrationSystem.d vibrationUser;
    private final DynamicGameEventListener<a> dynamicJukeboxListener;
    private final InventorySubcontainer inventory = new InventorySubcontainer(1);
    @Nullable
    public BlockPosition jukeboxPos;
    public long duplicationCooldown;
    private float holdingItemAnimationTicks;
    private float holdingItemAnimationTicks0;
    private float dancingAnimationTicks;
    private float spinningAnimationTicks;
    private float spinningAnimationTicks0;

    public Allay(EntityTypes<? extends Allay> var0, World var1) {
        super((EntityTypes<? extends EntityCreature>)var0, var1);
        this.moveControl = new ControllerMoveFlying(this, 20, true);
        this.setCanPickUpLoot(this.canPickUpLoot());
        this.vibrationUser = new b();
        this.vibrationData = new VibrationSystem.a();
        this.dynamicVibrationListener = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.dynamicJukeboxListener = new DynamicGameEventListener<a>(new a(this.vibrationUser.getPositionSource(), GameEvent.JUKEBOX_PLAY.value().notificationRadius()));
    }

    protected BehaviorController.b<Allay> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return AllayAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Allay> getBrain() {
        return super.getBrain();
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 20.0).add(GenericAttributes.FLYING_SPEED, 0.1f).add(GenericAttributes.MOVEMENT_SPEED, 0.1f).add(GenericAttributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        NavigationFlying var1 = new NavigationFlying(this, var0);
        var1.setCanOpenDoors(false);
        var1.setCanFloat(true);
        var1.setCanPassDoors(true);
        var1.setRequiredPathLength(48.0f);
        return var1;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_DANCING, false);
        var0.define(DATA_CAN_DUPLICATE, true);
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.91f));
            }
        }
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        Entity entity = var1.getEntity();
        if (entity instanceof EntityHuman) {
            EntityHuman var3 = (EntityHuman)entity;
            Optional<UUID> var4 = this.getBrain().getMemory(MemoryModuleType.LIKED_PLAYER);
            if (var4.isPresent() && var3.getUUID().equals(var4.get())) {
                return false;
            }
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return this.hasItemInSlot(EnumItemSlot.MAINHAND) ? SoundEffects.ALLAY_AMBIENT_WITH_ITEM : SoundEffects.ALLAY_AMBIENT_WITHOUT_ITEM;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ALLAY_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ALLAY_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("allayBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        var1.push("allayActivityUpdate");
        AllayAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isAlive() && this.tickCount % 10 == 0) {
            this.heal(1.0f);
        }
        if (this.isDancing() && this.shouldStopDancing() && this.tickCount % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
        this.updateDuplicationCooldown();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.holdingItemAnimationTicks0 = this.holdingItemAnimationTicks;
            this.holdingItemAnimationTicks = this.hasItemInHand() ? MathHelper.clamp(this.holdingItemAnimationTicks + 1.0f, 0.0f, 5.0f) : MathHelper.clamp(this.holdingItemAnimationTicks - 1.0f, 0.0f, 5.0f);
            if (this.isDancing()) {
                this.dancingAnimationTicks += 1.0f;
                this.spinningAnimationTicks0 = this.spinningAnimationTicks;
                this.spinningAnimationTicks = this.isSpinning() ? (this.spinningAnimationTicks += 1.0f) : (this.spinningAnimationTicks -= 1.0f);
                this.spinningAnimationTicks = MathHelper.clamp(this.spinningAnimationTicks, 0.0f, 15.0f);
            } else {
                this.dancingAnimationTicks = 0.0f;
                this.spinningAnimationTicks = 0.0f;
                this.spinningAnimationTicks0 = 0.0f;
            }
        } else {
            VibrationSystem.c.tick(this.level(), this.vibrationData, this.vibrationUser);
            if (this.isPanicking()) {
                this.setDancing(false);
            }
        }
    }

    @Override
    public boolean canPickUpLoot() {
        return !this.isOnPickupCooldown() && this.hasItemInHand();
    }

    public boolean hasItemInHand() {
        return !this.getItemInHand(EnumHand.MAIN_HAND).isEmpty();
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EnumItemSlot var0) {
        return false;
    }

    private boolean isOnPickupCooldown() {
        return this.getBrain().checkMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryStatus.VALUE_PRESENT);
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        ItemStack var3 = this.getItemInHand(EnumHand.MAIN_HAND);
        if (this.isDancing() && var2.is(TagsItem.DUPLICATES_ALLAYS) && this.canDuplicate()) {
            this.duplicateAllay();
            this.level().broadcastEntityEvent(this, (byte)18);
            this.level().playSound(var0, this, SoundEffects.AMETHYST_BLOCK_CHIME, SoundCategory.NEUTRAL, 2.0f, 1.0f);
            this.removeInteractionItem(var0, var2);
            return EnumInteractionResult.SUCCESS;
        }
        if (var3.isEmpty() && !var2.isEmpty()) {
            ItemStack var4 = var2.copyWithCount(1);
            this.setItemInHand(EnumHand.MAIN_HAND, var4);
            this.removeInteractionItem(var0, var2);
            this.level().playSound(var0, this, SoundEffects.ALLAY_ITEM_GIVEN, SoundCategory.NEUTRAL, 2.0f, 1.0f);
            this.getBrain().setMemory(MemoryModuleType.LIKED_PLAYER, var0.getUUID());
            return EnumInteractionResult.SUCCESS;
        }
        if (!var3.isEmpty() && var1 == EnumHand.MAIN_HAND && var2.isEmpty()) {
            this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
            this.level().playSound(var0, this, SoundEffects.ALLAY_ITEM_TAKEN, SoundCategory.NEUTRAL, 2.0f, 1.0f);
            this.swing(EnumHand.MAIN_HAND);
            for (ItemStack var5 : this.getInventory().removeAllItems()) {
                BehaviorUtil.throwItem(this, var5, this.position());
            }
            this.getBrain().eraseMemory(MemoryModuleType.LIKED_PLAYER);
            var0.addItem(var3);
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    public void setJukeboxPlaying(BlockPosition var0, boolean var1) {
        if (var1) {
            if (!this.isDancing()) {
                this.jukeboxPos = var0;
                this.setDancing(true);
            }
        } else if (var0.equals(this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    @Override
    public InventorySubcontainer getInventory() {
        return this.inventory;
    }

    @Override
    protected BaseBlockPosition getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    @Override
    public boolean wantsToPickUp(WorldServer var0, ItemStack var1) {
        ItemStack var2 = this.getItemInHand(EnumHand.MAIN_HAND);
        return !var2.isEmpty() && var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && this.inventory.canAddItem(var1) && this.allayConsidersItemEqual(var2, var1);
    }

    private boolean allayConsidersItemEqual(ItemStack var0, ItemStack var1) {
        return ItemStack.isSameItem(var0, var1) && !this.hasNonMatchingPotion(var0, var1);
    }

    private boolean hasNonMatchingPotion(ItemStack var0, ItemStack var1) {
        PotionContents var3;
        PotionContents var2 = var0.get(DataComponents.POTION_CONTENTS);
        return !Objects.equals(var2, var3 = var1.get(DataComponents.POTION_CONTENTS));
    }

    @Override
    protected void pickUpItem(WorldServer var0, EntityItem var1) {
        InventoryCarrier.pickUpItem(var0, this, this, var1);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public boolean isFlapping() {
        return !this.onGround();
    }

    @Override
    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, WorldServer> var0) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            var0.accept(this.dynamicVibrationListener, var1);
            var0.accept(this.dynamicJukeboxListener, var1);
        }
    }

    public boolean isDancing() {
        return this.entityData.get(DATA_DANCING);
    }

    public void setDancing(boolean var0) {
        if (this.level().isClientSide || !this.isEffectiveAi() || var0 && this.isPanicking()) {
            return;
        }
        this.entityData.set(DATA_DANCING, var0);
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.closerToCenterThan(this.position(), GameEvent.JUKEBOX_PLAY.value().notificationRadius()) || !this.level().getBlockState(this.jukeboxPos).is(Blocks.JUKEBOX);
    }

    public float getHoldingItemAnimationProgress(float var0) {
        return MathHelper.lerp(var0, this.holdingItemAnimationTicks0, this.holdingItemAnimationTicks) / 5.0f;
    }

    public boolean isSpinning() {
        float var0 = this.dancingAnimationTicks % 55.0f;
        return var0 < 15.0f;
    }

    public float getSpinningProgress(float var0) {
        return MathHelper.lerp(var0, this.spinningAnimationTicks0, this.spinningAnimationTicks) / 15.0f;
    }

    @Override
    public boolean equipmentHasChanged(ItemStack var0, ItemStack var1) {
        return !this.allayConsidersItemEqual(var0, var1);
    }

    @Override
    protected void dropEquipment(WorldServer var0) {
        super.dropEquipment(var0);
        this.inventory.removeAllItems().forEach(var1 -> this.spawnAtLocation(var0, (ItemStack)var1));
        ItemStack var12 = this.getItemBySlot(EnumItemSlot.MAINHAND);
        if (!var12.isEmpty() && !EnchantmentManager.has(var12, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
            this.spawnAtLocation(var0, var12);
            this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return false;
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var02) {
        super.addAdditionalSaveData(var02);
        this.writeInventoryToTag(var02, this.registryAccess());
        RegistryOps<NBTBase> var12 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        VibrationSystem.a.CODEC.encodeStart(var12, (Object)this.vibrationData).resultOrPartial(var0 -> LOGGER.error("Failed to encode vibration listener for Allay: '{}'", var0)).ifPresent(var1 -> var02.put("listener", (NBTBase)var1));
        var02.putLong("DuplicationCooldown", this.duplicationCooldown);
        var02.putBoolean("CanDuplicate", this.canDuplicate());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        this.readInventoryFromTag(var02, this.registryAccess());
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        if (var02.contains("listener", 10)) {
            VibrationSystem.a.CODEC.parse(var1, (Object)var02.getCompound("listener")).resultOrPartial(var0 -> LOGGER.error("Failed to parse vibration listener for Allay: '{}'", var0)).ifPresent(var0 -> {
                this.vibrationData = var0;
            });
        }
        this.duplicationCooldown = var02.getInt("DuplicationCooldown");
        this.entityData.set(DATA_CAN_DUPLICATE, var02.getBoolean("CanDuplicate"));
    }

    @Override
    protected boolean shouldStayCloseToLeashHolder() {
        return false;
    }

    private void updateDuplicationCooldown() {
        if (this.duplicationCooldown > 0L) {
            --this.duplicationCooldown;
        }
        if (!this.level().isClientSide() && this.duplicationCooldown == 0L && !this.canDuplicate()) {
            this.entityData.set(DATA_CAN_DUPLICATE, true);
        }
    }

    public void duplicateAllay() {
        Allay var0 = EntityTypes.ALLAY.create(this.level(), EntitySpawnReason.BREEDING);
        if (var0 != null) {
            var0.moveTo(this.position());
            var0.setPersistenceRequired();
            var0.resetDuplicationCooldown();
            this.resetDuplicationCooldown();
            this.level().addFreshEntity(var0);
        }
    }

    public void resetDuplicationCooldown() {
        this.duplicationCooldown = 6000L;
        this.entityData.set(DATA_CAN_DUPLICATE, false);
    }

    public boolean canDuplicate() {
        return this.entityData.get(DATA_CAN_DUPLICATE);
    }

    private void removeInteractionItem(EntityHuman var0, ItemStack var1) {
        var1.consume(1, var0);
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, (double)this.getEyeHeight() * 0.6, (double)this.getBbWidth() * 0.1);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 18) {
            for (int var1 = 0; var1 < 3; ++var1) {
                this.spawnHeartParticle();
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }

    private void spawnHeartParticle() {
        double var0 = this.random.nextGaussian() * 0.02;
        double var2 = this.random.nextGaussian() * 0.02;
        double var4 = this.random.nextGaussian() * 0.02;
        this.level().addParticle(Particles.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var0, var2, var4);
    }

    @Override
    public VibrationSystem.a getVibrationData() {
        return this.vibrationData;
    }

    @Override
    public VibrationSystem.d getVibrationUser() {
        return this.vibrationUser;
    }

    class b
    implements VibrationSystem.d {
        private static final int VIBRATION_EVENT_LISTENER_RANGE = 16;
        private final PositionSource positionSource;

        b() {
            this.positionSource = new EntityPositionSource(Allay.this, Allay.this.getEyeHeight());
        }

        @Override
        public int getListenerRadius() {
            return 16;
        }

        @Override
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @Override
        public boolean canReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, GameEvent.a var3) {
            if (Allay.this.isNoAi()) {
                return false;
            }
            Optional<GlobalPos> var4 = Allay.this.getBrain().getMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
            if (var4.isEmpty()) {
                return true;
            }
            GlobalPos var5 = var4.get();
            return var5.isCloseEnough(var0.dimension(), Allay.this.blockPosition(), 1024) && var5.pos().equals(var1);
        }

        @Override
        public void onReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, @Nullable Entity var3, @Nullable Entity var4, float var5) {
            if (var2.is(GameEvent.NOTE_BLOCK_PLAY)) {
                AllayAi.hearNoteblock(Allay.this, new BlockPosition(var1));
            }
        }

        @Override
        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.ALLAY_CAN_LISTEN;
        }
    }

    class a
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public a(PositionSource var1, int var2) {
            this.listenerSource = var1;
            this.listenerRadius = var2;
        }

        @Override
        public PositionSource getListenerSource() {
            return this.listenerSource;
        }

        @Override
        public int getListenerRadius() {
            return this.listenerRadius;
        }

        @Override
        public boolean handleGameEvent(WorldServer var0, Holder<GameEvent> var1, GameEvent.a var2, Vec3D var3) {
            if (var1.is(GameEvent.JUKEBOX_PLAY)) {
                Allay.this.setJukeboxPlaying(BlockPosition.containing(var3), true);
                return true;
            }
            if (var1.is(GameEvent.JUKEBOX_STOP_PLAY)) {
                Allay.this.setJukeboxPlaying(BlockPosition.containing(var3), false);
                return true;
            }
            return false;
        }
    }
}

