/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IEntityAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable,
VariantHolder<Holder<WolfVariant>> {
    private static final DataWatcherObject<Boolean> DATA_INTERESTED_ID = DataWatcher.defineId(EntityWolf.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_COLLAR_COLOR = DataWatcher.defineId(EntityWolf.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_REMAINING_ANGER_TIME = DataWatcher.defineId(EntityWolf.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Holder<WolfVariant>> DATA_VARIANT_ID = DataWatcher.defineId(EntityWolf.class, DataWatcherRegistry.WOLF_VARIANT);
    public static final PathfinderTargetCondition.a PREY_SELECTOR = (var0, var1) -> {
        EntityTypes<?> var2 = var0.getType();
        return var2 == EntityTypes.SHEEP || var2 == EntityTypes.RABBIT || var2 == EntityTypes.FOX;
    };
    private static final float START_HEALTH = 8.0f;
    private static final float TAME_HEALTH = 40.0f;
    private static final float ARMOR_REPAIR_UNIT = 0.125f;
    public static final float DEFAULT_TAIL_ANGLE = 0.62831855f;
    private float interestedAngle;
    private float interestedAngleO;
    public boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeRange.rangeOfSeconds(20, 39);
    @Nullable
    private UUID persistentAngerTarget;

    public EntityWolf(EntityTypes<? extends EntityWolf> var0, World var1) {
        super((EntityTypes<? extends EntityTameableAnimal>)var0, var1);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, new PathfinderGoalSit(this));
        this.goalSelector.addGoal(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.goalSelector.addGoal(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.goalSelector.addGoal(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(9, new PathfinderGoalBeg(this, 8.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.targetSelector.addGoal(2, new PathfinderGoalOwnerHurtTarget(this));
        this.targetSelector.addGoal(3, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.targetSelector.addGoal(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey getTexture() {
        WolfVariant var0 = (WolfVariant)this.getVariant().value();
        if (this.isTame()) {
            return var0.tameTexture();
        }
        if (this.isAngry()) {
            return var0.angryTexture();
        }
        return var0.wildTexture();
    }

    @Override
    public Holder<WolfVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    public void setVariant(Holder<WolfVariant> var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.MAX_HEALTH, 8.0).add(GenericAttributes.ATTACK_DAMAGE, 4.0);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        IRegistryCustom var1 = this.registryAccess();
        HolderLookup.b var2 = var1.lookupOrThrow(Registries.WOLF_VARIANT);
        var0.define(DATA_VARIANT_ID, (Holder)var2.get(WolfVariants.DEFAULT).or(((IRegistry)var2)::getAny).orElseThrow());
        var0.define(DATA_INTERESTED_ID, false);
        var0.define(DATA_COLLAR_COLOR, EnumColor.RED.getId());
        var0.define(DATA_REMAINING_ANGER_TIME, 0);
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.WOLF_STEP, 0.15f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("CollarColor", (byte)this.getCollarColor().getId());
        this.getVariant().unwrapKey().ifPresent(var1 -> var0.putString("variant", var1.location().toString()));
        this.addPersistentAngerSaveData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        Optional.ofNullable(MinecraftKey.tryParse(var02.getString("variant"))).map(var0 -> ResourceKey.create(Registries.WOLF_VARIANT, var0)).flatMap(var0 -> this.registryAccess().lookupOrThrow(Registries.WOLF_VARIANT).get((ResourceKey)var0)).ifPresent(this::setVariant);
        if (var02.contains("CollarColor", 99)) {
            this.setCollarColor(EnumColor.byId(var02.getInt("CollarColor")));
        }
        this.readPersistentAngerSaveData((World)this.level(), var02);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        Holder<WolfVariant> var5;
        Holder<BiomeBase> var4 = var0.getBiome(this.blockPosition());
        if (var3 instanceof b) {
            b var6 = (b)var3;
            var5 = var6.type;
        } else {
            var5 = WolfVariants.getSpawnVariant(this.registryAccess(), var4);
            var3 = new b(var5);
        }
        this.setVariant(var5);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isAngry()) {
            return SoundEffects.WOLF_GROWL;
        }
        if (this.random.nextInt(3) == 0) {
            if (this.isTame() && this.getHealth() < 20.0f) {
                return SoundEffects.WOLF_WHINE;
            }
            return SoundEffects.WOLF_PANT;
        }
        return SoundEffects.WOLF_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.canArmorAbsorb(var0)) {
            return SoundEffects.WOLF_ARMOR_DAMAGE;
        }
        return SoundEffects.WOLF_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WOLF_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!((World)this.level()).isClientSide && this.isWet && !this.isShaking && !this.isPathFinding() && this.onGround()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            ((World)this.level()).broadcastEntityEvent(this, (byte)8);
        }
        if (!((World)this.level()).isClientSide) {
            this.updatePersistentAnger((WorldServer)this.level(), true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isAlive()) {
            return;
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        if (this.isInWaterRainOrBubble()) {
            this.isWet = true;
            if (this.isShaking && !((World)this.level()).isClientSide) {
                ((World)this.level()).broadcastEntityEvent(this, (byte)56);
                this.cancelShake();
            }
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.shakeAnim == 0.0f) {
                this.playSound(SoundEffects.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.gameEvent(GameEvent.ENTITY_ACTION);
            }
            this.shakeAnimO = this.shakeAnim;
            this.shakeAnim += 0.05f;
            if (this.shakeAnimO >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.shakeAnimO = 0.0f;
                this.shakeAnim = 0.0f;
            }
            if (this.shakeAnim > 0.4f) {
                float var0 = (float)this.getY();
                int var1 = (int)(MathHelper.sin((this.shakeAnim - 0.4f) * (float)Math.PI) * 7.0f);
                Vec3D var2 = this.getDeltaMovement();
                for (int var3 = 0; var3 < var1; ++var3) {
                    float var4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    float var5 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    ((World)this.level()).addParticle(Particles.SPLASH, this.getX() + (double)var4, var0 + 0.8f, this.getZ() + (double)var5, var2.x, var2.y, var2.z);
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void die(DamageSource var0) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.die(var0);
    }

    public float getWetShade(float var0) {
        if (!this.isWet) {
            return 1.0f;
        }
        return Math.min(0.75f + MathHelper.lerp(var0, this.shakeAnimO, this.shakeAnim) / 2.0f * 0.25f, 1.0f);
    }

    public float getShakeAnim(float var0) {
        return MathHelper.lerp(var0, this.shakeAnimO, this.shakeAnim);
    }

    public float getHeadRollAngle(float var0) {
        return MathHelper.lerp(var0, this.interestedAngleO, this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    @Override
    public int getMaxHeadXRot() {
        if (this.isInSittingPose()) {
            return 20;
        }
        return super.getMaxHeadXRot();
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isInvulnerableTo(var0, var1)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        return true;
    }

    @Override
    protected void actuallyHurt(WorldServer var0, DamageSource var1, float var2) {
        if (!this.canArmorAbsorb(var1)) {
            super.actuallyHurt(var0, var1, var2);
            return;
        }
        ItemStack var3 = this.getBodyArmorItem();
        int var4 = var3.getDamageValue();
        int var5 = var3.getMaxDamage();
        var3.hurtAndBreak(MathHelper.ceil(var2), this, EnumItemSlot.BODY);
        if (Crackiness.WOLF_ARMOR.byDamage(var4, var5) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
            this.playSound(SoundEffects.WOLF_ARMOR_CRACK);
            var0.sendParticles(new ParticleParamItem(Particles.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
        }
    }

    private boolean canArmorAbsorb(DamageSource var0) {
        return this.getBodyArmorItem().is(Items.WOLF_ARMOR) && !var0.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    @Override
    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(40.0f);
        } else {
            this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    @Override
    protected void hurtArmor(DamageSource var0, float var1) {
        this.doHurtEquipment(var0, var1, EnumItemSlot.BODY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        Item var3 = var2.getItem();
        if (this.isTame()) {
            if (this.isFood(var2) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(var0, var1, var2);
                FoodInfo var5 = var2.get(DataComponents.FOOD);
                float var6 = var5 != null ? (float)var5.nutrition() : 1.0f;
                this.heal(2.0f * var6);
                return EnumInteractionResult.SUCCESS;
            }
            if (var3 instanceof ItemDye) {
                ItemDye var4 = (ItemDye)var3;
                if (this.isOwnedBy(var0)) {
                    EnumColor var5 = var4.getDyeColor();
                    if (var5 == this.getCollarColor()) return super.mobInteract(var0, var1);
                    this.setCollarColor(var5);
                    var2.consume(1, var0);
                    return EnumInteractionResult.SUCCESS;
                }
            }
            if (this.isEquippableInSlot(var2, EnumItemSlot.BODY) && !this.isWearingBodyArmor() && this.isOwnedBy(var0) && !this.isBaby()) {
                this.setBodyArmorItem(var2.copyWithCount(1));
                var2.consume(1, var0);
                return EnumInteractionResult.SUCCESS;
            }
            if (var2.is(Items.SHEARS) && this.isOwnedBy(var0) && this.isWearingBodyArmor() && (!EnchantmentManager.has(this.getBodyArmorItem(), EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) || var0.isCreative())) {
                var2.hurtAndBreak(1, var0, EntityWolf.getSlotForHand(var1));
                this.playSound(SoundEffects.ARMOR_UNEQUIP_WOLF);
                ItemStack var5 = this.getBodyArmorItem();
                this.setBodyArmorItem(ItemStack.EMPTY);
                IEntityAccess iEntityAccess = this.level();
                if (!(iEntityAccess instanceof WorldServer)) return EnumInteractionResult.SUCCESS;
                WorldServer var6 = (WorldServer)iEntityAccess;
                this.spawnAtLocation(var6, var5);
                return EnumInteractionResult.SUCCESS;
            }
            if (this.isInSittingPose() && this.isWearingBodyArmor() && this.isOwnedBy(var0) && this.getBodyArmorItem().isDamaged() && this.getBodyArmorItem().isValidRepairItem(var2)) {
                var2.shrink(1);
                this.playSound(SoundEffects.WOLF_ARMOR_REPAIR);
                ItemStack var5 = this.getBodyArmorItem();
                int var6 = (int)((float)var5.getMaxDamage() * 0.125f);
                var5.setDamageValue(Math.max(0, var5.getDamageValue() - var6));
                return EnumInteractionResult.SUCCESS;
            }
            EnumInteractionResult var5 = super.mobInteract(var0, var1);
            if (var5.consumesAction() || !this.isOwnedBy(var0)) return var5;
            this.setOrderedToSit(!this.isOrderedToSit());
            this.jumping = false;
            this.navigation.stop();
            this.setTarget(null);
            return EnumInteractionResult.SUCCESS.withoutItem();
        }
        if (((World)this.level()).isClientSide || !var2.is(Items.BONE) || this.isAngry()) return super.mobInteract(var0, var1);
        var2.consume(1, var0);
        this.tryToTame(var0);
        return EnumInteractionResult.SUCCESS_SERVER;
    }

    private void tryToTame(EntityHuman var0) {
        if (this.random.nextInt(3) == 0) {
            this.tame(var0);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            ((World)this.level()).broadcastEntityEvent(this, (byte)7);
        } else {
            ((World)this.level()).broadcastEntityEvent(this, (byte)6);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (var0 == 56) {
            this.cancelShake();
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (this.isTame()) {
            float var0 = this.getMaxHealth();
            float var1 = (var0 - this.getHealth()) / var0;
            return (0.55f - var1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.WOLF_FOOD);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 8;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void setRemainingPersistentAngerTime(int var0) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, var0);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID var0) {
        this.persistentAngerTarget = var0;
    }

    public EnumColor getCollarColor() {
        return EnumColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    public void setCollarColor(EnumColor var0) {
        this.entityData.set(DATA_COLLAR_COLOR, var0.getId());
    }

    @Override
    @Nullable
    public EntityWolf getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityWolf var2 = EntityTypes.WOLF.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null && var1 instanceof EntityWolf) {
            EntityWolf var3 = (EntityWolf)var1;
            if (this.random.nextBoolean()) {
                var2.setVariant((Holder<WolfVariant>)this.getVariant());
            } else {
                var2.setVariant((Holder<WolfVariant>)var3.getVariant());
            }
            if (this.isTame()) {
                var2.setOwnerUUID(this.getOwnerUUID());
                var2.setTame(true, true);
                if (this.random.nextBoolean()) {
                    var2.setCollarColor(this.getCollarColor());
                } else {
                    var2.setCollarColor(var3.getCollarColor());
                }
            }
        }
        return var2;
    }

    public void setIsInterested(boolean var0) {
        this.entityData.set(DATA_INTERESTED_ID, var0);
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(var0 instanceof EntityWolf)) {
            return false;
        }
        EntityWolf var1 = (EntityWolf)var0;
        if (!var1.isTame()) {
            return false;
        }
        if (var1.isInSittingPose()) {
            return false;
        }
        return this.isInLove() && var1.isInLove();
    }

    public boolean isInterested() {
        return this.entityData.get(DATA_INTERESTED_ID);
    }

    @Override
    public boolean wantsToAttack(EntityLiving var0, EntityLiving var1) {
        EntityLiving var2;
        if (var0 instanceof EntityCreeper || var0 instanceof EntityGhast || var0 instanceof EntityArmorStand) {
            return false;
        }
        if (var0 instanceof EntityWolf) {
            EntityWolf var22 = (EntityWolf)var0;
            return !var22.isTame() || var22.getOwner() != var1;
        }
        if (var0 instanceof EntityHuman) {
            EntityHuman var3;
            var2 = (EntityHuman)var0;
            if (var1 instanceof EntityHuman && !(var3 = (EntityHuman)var1).canHarmPlayer((EntityHuman)var2)) {
                return false;
            }
        }
        if (var0 instanceof EntityHorseAbstract && ((EntityHorseAbstract)(var2 = (EntityHorseAbstract)var0)).isTamed()) {
            return false;
        }
        return !(var0 instanceof EntityTameableAnimal) || !((EntityTameableAnimal)(var2 = (EntityTameableAnimal)var0)).isTame();
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAngry();
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public static boolean checkWolfSpawnRules(EntityTypes<EntityWolf> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.WOLVES_SPAWNABLE_ON) && EntityWolf.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    @Override
    public /* synthetic */ void setVariant(Object object) {
        this.setVariant((Holder)object);
    }

    class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf wolf;

        public a(EntityWolf var1, Class var2, float var3, double var4, double var6) {
            super(var1, var2, var3, var4, var6);
            this.wolf = var1;
        }

        @Override
        public boolean canUse() {
            if (super.canUse() && this.toAvoid instanceof EntityLlama) {
                return !this.wolf.isTame() && this.avoidLlama((EntityLlama)this.toAvoid);
            }
            return false;
        }

        private boolean avoidLlama(EntityLlama var0) {
            return var0.getStrength() >= EntityWolf.this.random.nextInt(5);
        }

        @Override
        public void start() {
            EntityWolf.this.setTarget(null);
            super.start();
        }

        @Override
        public void tick() {
            EntityWolf.this.setTarget(null);
            super.tick();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> type;

        public b(Holder<WolfVariant> var0) {
            super(false);
            this.type = var0;
        }
    }
}

