/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;

public class EntitySalmon
extends EntityFishSchool
implements VariantHolder<a> {
    private static final DataWatcherObject<String> DATA_TYPE = DataWatcher.defineId(EntitySalmon.class, DataWatcherRegistry.STRING);

    public EntitySalmon(EntityTypes<? extends EntitySalmon> var0, World var1) {
        super((EntityTypes<? extends EntityFishSchool>)var0, var1);
        this.refreshDimensions();
    }

    @Override
    public int getMaxSchoolSize() {
        return 5;
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.SALMON_BUCKET);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SALMON_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SALMON_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SALMON_HURT;
    }

    @Override
    protected SoundEffect getFlopSound() {
        return SoundEffects.SALMON_FLOP;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_TYPE, a.MEDIUM.type);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_TYPE.equals(var0)) {
            this.refreshDimensions();
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putString("type", this.getVariant().getSerializedName());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(a.byName(var0.getString("type")));
    }

    @Override
    public void saveToBucketTag(ItemStack var02) {
        Bucketable.saveDefaultDataToBucketTag(this, var02);
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, var02, var0 -> var0.putString("type", this.getVariant().getSerializedName()));
    }

    @Override
    public void loadFromBucketTag(NBTTagCompound var0) {
        Bucketable.loadDefaultDataFromBucketTag(this, var0);
        this.setVariant(a.byName(var0.getString("type")));
    }

    @Override
    public void setVariant(a var0) {
        this.entityData.set(DATA_TYPE, var0.type);
    }

    @Override
    public a getVariant() {
        return a.byName(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        SimpleWeightedRandomList.a<a> var4 = SimpleWeightedRandomList.builder();
        var4.add(a.SMALL, 30);
        var4.add(a.MEDIUM, 50);
        var4.add(a.LARGE, 15);
        var4.build().getRandomValue(this.random).ifPresent(this::setVariant);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public float getSalmonScale() {
        return this.getVariant().boundingBoxScale;
    }

    @Override
    protected EntitySize getDefaultDimensions(EntityPose var0) {
        return super.getDefaultDimensions(var0).scale(this.getSalmonScale());
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a SMALL = new a("small", 0.5f);
        public static final /* enum */ a MEDIUM = new a("medium", 1.0f);
        public static final /* enum */ a LARGE = new a("large", 1.5f);
        public static final INamable.a<a> CODEC;
        final String type;
        final float boundingBoxScale;
        private static final /* synthetic */ a[] g;

        public static a[] values() {
            return (a[])g.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2, float var3) {
            this.type = var2;
            this.boundingBoxScale = var3;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        static a byName(String var0) {
            return CODEC.byName(var0, MEDIUM);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{SMALL, MEDIUM, LARGE};
        }

        static {
            g = a.a();
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

