/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.AxisAlignedBB;

public class EntityCat
extends EntityTameableAnimal
implements VariantHolder<Holder<CatVariant>> {
    public static final double TEMPT_SPEED_MOD = 0.6;
    public static final double WALK_SPEED_MOD = 0.8;
    public static final double SPRINT_SPEED_MOD = 1.33;
    private static final DataWatcherObject<Holder<CatVariant>> DATA_VARIANT_ID = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.CAT_VARIANT);
    private static final DataWatcherObject<Boolean> IS_LYING = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> RELAX_STATE_ONE = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_COLLAR_COLOR = DataWatcher.defineId(EntityCat.class, DataWatcherRegistry.INT);
    private static final ResourceKey<CatVariant> DEFAULT_VARIANT = CatVariant.BLACK;
    @Nullable
    private a<EntityHuman> avoidPlayersGoal;
    @Nullable
    private PathfinderGoalTempt temptGoal;
    private float lieDownAmount;
    private float lieDownAmountO;
    private float lieDownAmountTail;
    private float lieDownAmountOTail;
    private boolean isLyingOnTopOfSleepingPlayer;
    private float relaxStateOneAmount;
    private float relaxStateOneAmountO;

    public EntityCat(EntityTypes<? extends EntityCat> var0, World var1) {
        super((EntityTypes<? extends EntityTameableAnimal>)var0, var1);
        this.reassessTameGoals();
    }

    @Override
    protected void registerGoals() {
        this.temptGoal = new PathfinderGoalTemptChance(this, 0.6, var0 -> var0.is(TagsItem.CAT_FOOD), true);
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new EntityTameableAnimal.a(1.5));
        this.goalSelector.addGoal(2, new PathfinderGoalSit(this));
        this.goalSelector.addGoal(3, new b(this));
        this.goalSelector.addGoal(4, this.temptGoal);
        this.goalSelector.addGoal(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.goalSelector.addGoal(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.goalSelector.addGoal(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.goalSelector.addGoal(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.goalSelector.addGoal(9, new PathfinderGoalOcelotAttack(this));
        this.goalSelector.addGoal(10, new PathfinderGoalBreed(this, 0.8));
        this.goalSelector.addGoal(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.goalSelector.addGoal(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.targetSelector.addGoal(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, null));
        this.targetSelector.addGoal(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
    }

    @Override
    public Holder<CatVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    public void setVariant(Holder<CatVariant> var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public void setLying(boolean var0) {
        this.entityData.set(IS_LYING, var0);
    }

    public boolean isLying() {
        return this.entityData.get(IS_LYING);
    }

    void setRelaxStateOne(boolean var0) {
        this.entityData.set(RELAX_STATE_ONE, var0);
    }

    boolean isRelaxStateOne() {
        return this.entityData.get(RELAX_STATE_ONE);
    }

    public EnumColor getCollarColor() {
        return EnumColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    public void setCollarColor(EnumColor var0) {
        this.entityData.set(DATA_COLLAR_COLOR, var0.getId());
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VARIANT_ID, BuiltInRegistries.CAT_VARIANT.getOrThrow(DEFAULT_VARIANT));
        var0.define(IS_LYING, false);
        var0.define(RELAX_STATE_ONE, false);
        var0.define(DATA_COLLAR_COLOR, EnumColor.RED.getId());
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putString("variant", this.getVariant().unwrapKey().orElse(DEFAULT_VARIANT).location().toString());
        var0.putByte("CollarColor", (byte)this.getCollarColor().getId());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        Optional.ofNullable(MinecraftKey.tryParse(var02.getString("variant"))).map(var0 -> ResourceKey.create(Registries.CAT_VARIANT, var0)).flatMap(BuiltInRegistries.CAT_VARIANT::get).ifPresent(this::setVariant);
        if (var02.contains("CollarColor", 99)) {
            this.setCollarColor(EnumColor.byId(var02.getInt("CollarColor")));
        }
    }

    @Override
    public void customServerAiStep(WorldServer var0) {
        if (this.getMoveControl().hasWanted()) {
            double var1 = this.getMoveControl().getSpeedModifier();
            if (var1 == 0.6) {
                this.setPose(EntityPose.CROUCHING);
                this.setSprinting(false);
            } else if (var1 == 1.33) {
                this.setPose(EntityPose.STANDING);
                this.setSprinting(true);
            } else {
                this.setPose(EntityPose.STANDING);
                this.setSprinting(false);
            }
        } else {
            this.setPose(EntityPose.STANDING);
            this.setSprinting(false);
        }
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (this.isTame()) {
            if (this.isInLove()) {
                return SoundEffects.CAT_PURR;
            }
            if (this.random.nextInt(4) == 0) {
                return SoundEffects.CAT_PURREOW;
            }
            return SoundEffects.CAT_AMBIENT;
        }
        return SoundEffects.CAT_STRAY_AMBIENT;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    public void hiss() {
        this.makeSound(SoundEffects.CAT_HISS);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CAT_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CAT_DEATH;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.ATTACK_DAMAGE, 3.0);
    }

    @Override
    protected void playEatingSound() {
        this.playSound(SoundEffects.CAT_EAT, 1.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.temptGoal != null && this.temptGoal.isRunning() && !this.isTame() && this.tickCount % 100 == 0) {
            this.playSound(SoundEffects.CAT_BEG_FOR_FOOD, 1.0f, 1.0f);
        }
        this.handleLieDown();
    }

    private void handleLieDown() {
        if ((this.isLying() || this.isRelaxStateOne()) && this.tickCount % 5 == 0) {
            this.playSound(SoundEffects.CAT_PURR, 0.6f + 0.4f * (this.random.nextFloat() - this.random.nextFloat()), 1.0f);
        }
        this.updateLieDownAmount();
        this.updateRelaxStateOneAmount();
        this.isLyingOnTopOfSleepingPlayer = false;
        if (this.isLying()) {
            BlockPosition var0 = this.blockPosition();
            List<EntityHuman> var1 = this.level().getEntitiesOfClass(EntityHuman.class, new AxisAlignedBB(var0).inflate(2.0, 2.0, 2.0));
            for (EntityHuman var3 : var1) {
                if (!var3.isSleeping()) continue;
                this.isLyingOnTopOfSleepingPlayer = true;
                break;
            }
        }
    }

    public boolean isLyingOnTopOfSleepingPlayer() {
        return this.isLyingOnTopOfSleepingPlayer;
    }

    private void updateLieDownAmount() {
        this.lieDownAmountO = this.lieDownAmount;
        this.lieDownAmountOTail = this.lieDownAmountTail;
        if (this.isLying()) {
            this.lieDownAmount = Math.min(1.0f, this.lieDownAmount + 0.15f);
            this.lieDownAmountTail = Math.min(1.0f, this.lieDownAmountTail + 0.08f);
        } else {
            this.lieDownAmount = Math.max(0.0f, this.lieDownAmount - 0.22f);
            this.lieDownAmountTail = Math.max(0.0f, this.lieDownAmountTail - 0.13f);
        }
    }

    private void updateRelaxStateOneAmount() {
        this.relaxStateOneAmountO = this.relaxStateOneAmount;
        this.relaxStateOneAmount = this.isRelaxStateOne() ? Math.min(1.0f, this.relaxStateOneAmount + 0.1f) : Math.max(0.0f, this.relaxStateOneAmount - 0.13f);
    }

    public float getLieDownAmount(float var0) {
        return MathHelper.lerp(var0, this.lieDownAmountO, this.lieDownAmount);
    }

    public float getLieDownAmountTail(float var0) {
        return MathHelper.lerp(var0, this.lieDownAmountOTail, this.lieDownAmountTail);
    }

    public float getRelaxStateOneAmount(float var0) {
        return MathHelper.lerp(var0, this.relaxStateOneAmountO, this.relaxStateOneAmount);
    }

    @Override
    @Nullable
    public EntityCat getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityCat var2 = EntityTypes.CAT.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null && var1 instanceof EntityCat) {
            EntityCat var3 = (EntityCat)var1;
            if (this.random.nextBoolean()) {
                var2.setVariant((Holder<CatVariant>)this.getVariant());
            } else {
                var2.setVariant((Holder<CatVariant>)var3.getVariant());
            }
            if (this.isTame()) {
                var2.setOwnerUUID(this.getOwnerUUID());
                var2.setTame(true, true);
                if (this.random.nextBoolean()) {
                    var2.setCollarColor(this.getCollarColor());
                } else {
                    var2.setCollarColor(var3.getCollarColor());
                }
            }
        }
        return var2;
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (!this.isTame()) {
            return false;
        }
        if (!(var0 instanceof EntityCat)) {
            return false;
        }
        EntityCat var1 = (EntityCat)var0;
        return var1.isTame() && super.canMate(var0);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        var3 = super.finalizeSpawn(var0, var1, var2, var3);
        boolean var4 = var0.getMoonBrightness() > 0.9f;
        TagKey<CatVariant> var5 = var4 ? CatVariantTags.FULL_MOON_SPAWNS : CatVariantTags.DEFAULT_SPAWNS;
        BuiltInRegistries.CAT_VARIANT.getRandomElementOf(var5, var0.getRandom()).ifPresent(this::setVariant);
        WorldServer var6 = var0.getLevel();
        if (var6.structureManager().getStructureWithPieceAt(this.blockPosition(), StructureTags.CATS_SPAWN_AS_BLACK).isValid()) {
            this.setVariant(BuiltInRegistries.CAT_VARIANT.getOrThrow(CatVariant.ALL_BLACK));
            this.setPersistenceRequired();
        }
        return var3;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        EnumInteractionResult var4;
        ItemStack var2 = var0.getItemInHand(var1);
        Item var3 = var2.getItem();
        if (this.isTame()) {
            if (this.isOwnedBy(var0)) {
                Object var42;
                if (var3 instanceof ItemDye) {
                    var42 = (ItemDye)var3;
                    EnumColor var5 = ((ItemDye)var42).getDyeColor();
                    if (var5 != this.getCollarColor()) {
                        if (!((World)this.level()).isClientSide()) {
                            this.setCollarColor(var5);
                            var2.consume(1, var0);
                            this.setPersistenceRequired();
                        }
                        return EnumInteractionResult.SUCCESS;
                    }
                } else if (this.isFood(var2) && this.getHealth() < this.getMaxHealth()) {
                    if (!((World)this.level()).isClientSide()) {
                        this.usePlayerItem(var0, var1, var2);
                        FoodInfo var5 = var2.get(DataComponents.FOOD);
                        this.heal(var5 != null ? (float)var5.nutrition() : 1.0f);
                        this.playEatingSound();
                    }
                    return EnumInteractionResult.SUCCESS;
                }
                if (!(var42 = super.mobInteract(var0, var1)).consumesAction()) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    return EnumInteractionResult.SUCCESS;
                }
                return var42;
            }
        } else if (this.isFood(var2)) {
            if (!((World)this.level()).isClientSide()) {
                this.usePlayerItem(var0, var1, var2);
                this.tryToTame(var0);
                this.setPersistenceRequired();
                this.playEatingSound();
            }
            return EnumInteractionResult.SUCCESS;
        }
        if ((var4 = super.mobInteract(var0, var1)).consumesAction()) {
            this.setPersistenceRequired();
        }
        return var4;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.CAT_FOOD);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.isTame() && this.tickCount > 2400;
    }

    @Override
    public void setTame(boolean var0, boolean var1) {
        super.setTame(var0, var1);
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.goalSelector.removeGoal(this.avoidPlayersGoal);
        if (!this.isTame()) {
            this.goalSelector.addGoal(4, this.avoidPlayersGoal);
        }
    }

    private void tryToTame(EntityHuman var0) {
        if (this.random.nextInt(3) == 0) {
            this.tame(var0);
            this.setOrderedToSit(true);
            ((World)this.level()).broadcastEntityEvent(this, (byte)7);
        } else {
            ((World)this.level()).broadcastEntityEvent(this, (byte)6);
        }
    }

    @Override
    public boolean isSteppingCarefully() {
        return this.isCrouching() || super.isSteppingCarefully();
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    @Override
    public /* synthetic */ void setVariant(Object object) {
        this.setVariant((Holder)object);
    }

    static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityHuman selectedPlayer;
        private final EntityCat cat;

        public PathfinderGoalTemptChance(EntityCat var0, double var1, Predicate<ItemStack> var3, boolean var4) {
            super(var0, var1, var3, var4);
            this.cat = var0;
        }

        @Override
        public void tick() {
            super.tick();
            if (this.selectedPlayer == null && this.mob.getRandom().nextInt(this.adjustedTickDelay(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.mob.getRandom().nextInt(this.adjustedTickDelay(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean canScare() {
            if (this.selectedPlayer != null && this.selectedPlayer.equals(this.player)) {
                return false;
            }
            return super.canScare();
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !this.cat.isTame();
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityCat cat;
        @Nullable
        private EntityHuman ownerPlayer;
        @Nullable
        private BlockPosition goalPos;
        private int onBedTicks;

        public b(EntityCat var0) {
            this.cat = var0;
        }

        @Override
        public boolean canUse() {
            if (!this.cat.isTame()) {
                return false;
            }
            if (this.cat.isOrderedToSit()) {
                return false;
            }
            EntityLiving var0 = this.cat.getOwner();
            if (var0 instanceof EntityHuman) {
                this.ownerPlayer = (EntityHuman)var0;
                if (!var0.isSleeping()) {
                    return false;
                }
                if (this.cat.distanceToSqr(this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPosition var12 = this.ownerPlayer.blockPosition();
                IBlockData var2 = ((World)this.cat.level()).getBlockState(var12);
                if (var2.is(TagsBlock.BEDS)) {
                    this.goalPos = var2.getOptionalValue(BlockBed.FACING).map(var1 -> var12.relative(var1.getOpposite())).orElseGet(() -> new BlockPosition(var12));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            List<EntityCat> var0 = this.cat.level().getEntitiesOfClass(EntityCat.class, new AxisAlignedBB(this.goalPos).inflate(2.0));
            for (EntityCat var2 : var0) {
                if (var2 == this.cat || !var2.isLying() && !var2.isRelaxStateOne()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            return this.cat.isTame() && !this.cat.isOrderedToSit() && this.ownerPlayer != null && this.ownerPlayer.isSleeping() && this.goalPos != null && !this.spaceIsOccupied();
        }

        @Override
        public void start() {
            if (this.goalPos != null) {
                this.cat.setInSittingPose(false);
                this.cat.getNavigation().moveTo(this.goalPos.getX(), this.goalPos.getY(), this.goalPos.getZ(), 1.1f);
            }
        }

        @Override
        public void stop() {
            this.cat.setLying(false);
            float var0 = this.cat.level().getTimeOfDay(1.0f);
            if (this.ownerPlayer.getSleepTimer() >= 100 && (double)var0 > 0.77 && (double)var0 < 0.8 && (double)((World)this.cat.level()).getRandom().nextFloat() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.cat.setRelaxStateOne(false);
            this.cat.getNavigation().stop();
        }

        private void giveMorningGift() {
            RandomSource var0 = this.cat.getRandom();
            BlockPosition.MutableBlockPosition var12 = new BlockPosition.MutableBlockPosition();
            var12.set(this.cat.isLeashed() ? this.cat.getLeashHolder().blockPosition() : this.cat.blockPosition());
            this.cat.randomTeleport(var12.getX() + var0.nextInt(11) - 5, var12.getY() + var0.nextInt(5) - 2, var12.getZ() + var0.nextInt(11) - 5, false);
            var12.set(this.cat.blockPosition());
            this.cat.dropFromGiftLootTable(b.getServerLevel(this.cat), LootTables.CAT_MORNING_GIFT, (var1, var2) -> var1.addFreshEntity(new EntityItem((World)var1, (double)var12.getX() - (double)MathHelper.sin(this.cat.yBodyRot * ((float)Math.PI / 180)), var12.getY(), (double)var12.getZ() + (double)MathHelper.cos(this.cat.yBodyRot * ((float)Math.PI / 180)), (ItemStack)var2)));
        }

        @Override
        public void tick() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.cat.setInSittingPose(false);
                this.cat.getNavigation().moveTo(this.goalPos.getX(), this.goalPos.getY(), this.goalPos.getZ(), 1.1f);
                if (this.cat.distanceToSqr(this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.adjustedTickDelay(16)) {
                        this.cat.setLying(true);
                        this.cat.setRelaxStateOne(false);
                    } else {
                        this.cat.lookAt(this.ownerPlayer, 45.0f, 45.0f);
                        this.cat.setRelaxStateOne(true);
                    }
                } else {
                    this.cat.setLying(false);
                }
            }
        }
    }

    static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat cat;

        public a(EntityCat var0, Class<T> var1, float var2, double var3, double var5) {
            super(var0, var1, var2, var3, var5, IEntitySelector.NO_CREATIVE_OR_SPECTATOR::test);
            this.cat = var0;
        }

        @Override
        public boolean canUse() {
            return !this.cat.isTame() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return !this.cat.isTame() && super.canContinueToUse();
        }
    }
}

