/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;

public class PathfinderGoalUtil {
    public static boolean hasGroundPathNavigation(EntityInsentient var0) {
        return var0.getNavigation() instanceof Navigation;
    }

    public static boolean mobRestricted(EntityCreature var0, int var1) {
        return var0.hasRestriction() && var0.getRestrictCenter().closerToCenterThan(var0.position(), (double)(var0.getRestrictRadius() + (float)var1) + 1.0);
    }

    public static boolean isOutsideLimits(BlockPosition var0, EntityCreature var1) {
        return var1.level().isOutsideBuildHeight(var0.getY());
    }

    public static boolean isRestricted(boolean var0, EntityCreature var1, BlockPosition var2) {
        return var0 && !var1.isWithinRestriction(var2);
    }

    public static boolean isNotStable(NavigationAbstract var0, BlockPosition var1) {
        return !var0.isStableDestination(var1);
    }

    public static boolean isWater(EntityCreature var0, BlockPosition var1) {
        return var0.level().getFluidState(var1).is(TagsFluid.WATER);
    }

    public static boolean hasMalus(EntityCreature var0, BlockPosition var1) {
        return var0.getPathfindingMalus(PathfinderNormal.getPathTypeStatic(var0, var1)) != 0.0f;
    }

    public static boolean isSolid(EntityCreature var0, BlockPosition var1) {
        return var0.level().getBlockState(var1).isSolid();
    }
}

