/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;

public class PathfinderGoalOwnerHurtByTarget
extends PathfinderGoalTarget {
    private final EntityTameableAnimal tameAnimal;
    private EntityLiving ownerLastHurtBy;
    private int timestamp;

    public PathfinderGoalOwnerHurtByTarget(EntityTameableAnimal var0) {
        super(var0, false);
        this.tameAnimal = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
    }

    @Override
    public boolean canUse() {
        if (!this.tameAnimal.isTame() || this.tameAnimal.isOrderedToSit()) {
            return false;
        }
        EntityLiving var0 = this.tameAnimal.getOwner();
        if (var0 == null) {
            return false;
        }
        this.ownerLastHurtBy = var0.getLastHurtByMob();
        int var1 = var0.getLastHurtByMobTimestamp();
        return var1 != this.timestamp && this.canAttack(this.ownerLastHurtBy, PathfinderTargetCondition.DEFAULT) && this.tameAnimal.wantsToAttack(this.ownerLastHurtBy, var0);
    }

    @Override
    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        EntityLiving var0 = this.tameAnimal.getOwner();
        if (var0 != null) {
            this.timestamp = var0.getLastHurtByMobTimestamp();
        }
        super.start();
    }
}

