/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalWaterJump
extends PathfinderGoalWaterJumpAbstract {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
    private final EntityDolphin dolphin;
    private final int interval;
    private boolean breached;

    public PathfinderGoalWaterJump(EntityDolphin var0, int var1) {
        this.dolphin = var0;
        this.interval = PathfinderGoalWaterJump.reducedTickDelay(var1);
    }

    @Override
    public boolean canUse() {
        if (this.dolphin.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        EnumDirection var0 = this.dolphin.getMotionDirection();
        int var1 = var0.getStepX();
        int var2 = var0.getStepZ();
        BlockPosition var3 = this.dolphin.blockPosition();
        for (int var7 : STEPS_TO_CHECK) {
            if (this.waterIsClear(var3, var1, var2, var7) && this.surfaceIsClear(var3, var1, var2, var7)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(BlockPosition var0, int var1, int var2, int var3) {
        BlockPosition var4 = var0.offset(var1 * var3, 0, var2 * var3);
        return this.dolphin.level().getFluidState(var4).is(TagsFluid.WATER) && !this.dolphin.level().getBlockState(var4).blocksMotion();
    }

    private boolean surfaceIsClear(BlockPosition var0, int var1, int var2, int var3) {
        return this.dolphin.level().getBlockState(var0.offset(var1 * var3, 1, var2 * var3)).isAir() && this.dolphin.level().getBlockState(var0.offset(var1 * var3, 2, var2 * var3)).isAir();
    }

    @Override
    public boolean canContinueToUse() {
        double var0 = this.dolphin.getDeltaMovement().y;
        return !(var0 * var0 < (double)0.03f && this.dolphin.getXRot() != 0.0f && Math.abs(this.dolphin.getXRot()) < 10.0f && this.dolphin.isInWater() || this.dolphin.onGround());
    }

    @Override
    public boolean isInterruptable() {
        return false;
    }

    @Override
    public void start() {
        EnumDirection var0 = this.dolphin.getMotionDirection();
        this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add((double)var0.getStepX() * 0.6, 0.7, (double)var0.getStepZ() * 0.6));
        this.dolphin.getNavigation().stop();
    }

    @Override
    public void stop() {
        this.dolphin.setXRot(0.0f);
    }

    @Override
    public void tick() {
        Object var1;
        boolean var0 = this.breached;
        if (!var0) {
            var1 = this.dolphin.level().getFluidState(this.dolphin.blockPosition());
            this.breached = ((Fluid)var1).is(TagsFluid.WATER);
        }
        if (this.breached && !var0) {
            this.dolphin.playSound(SoundEffects.DOLPHIN_JUMP, 1.0f, 1.0f);
        }
        var1 = this.dolphin.getDeltaMovement();
        if (((Vec3D)var1).y * ((Vec3D)var1).y < (double)0.03f && this.dolphin.getXRot() != 0.0f) {
            this.dolphin.setXRot(MathHelper.rotLerp(0.2f, this.dolphin.getXRot(), 0.0f));
        } else if (((Vec3D)var1).length() > (double)1.0E-5f) {
            double var2 = ((Vec3D)var1).horizontalDistance();
            double var4 = Math.atan2(-((Vec3D)var1).y, var2) * 57.2957763671875;
            this.dolphin.setXRot((float)var4);
        }
    }
}

