/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalRemoveBlock
extends PathfinderGoalGotoTarget {
    private final Block blockToRemove;
    private final EntityInsentient removerMob;
    private int ticksSinceReachedGoal;
    private static final int WAIT_AFTER_BLOCK_FOUND = 20;

    public PathfinderGoalRemoveBlock(Block var0, EntityCreature var1, double var2, int var4) {
        super(var1, var2, 24, var4);
        this.blockToRemove = var0;
        this.removerMob = var1;
    }

    @Override
    public boolean canUse() {
        if (!PathfinderGoalRemoveBlock.getServerLevel(this.removerMob).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.findNearestBlock()) {
            this.nextStartTick = PathfinderGoalRemoveBlock.reducedTickDelay(20);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        this.removerMob.fallDistance = 1.0f;
    }

    @Override
    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(GeneratorAccess var0, BlockPosition var1) {
    }

    public void playBreakSound(World var0, BlockPosition var1) {
    }

    @Override
    public void tick() {
        super.tick();
        World var0 = this.removerMob.level();
        BlockPosition var1 = this.removerMob.blockPosition();
        BlockPosition var2 = this.getPosWithBlock(var1, var0);
        RandomSource var3 = this.removerMob.getRandom();
        if (this.isReachedTarget() && var2 != null) {
            double var5;
            Vec3D var4;
            if (this.ticksSinceReachedGoal > 0) {
                var4 = this.removerMob.getDeltaMovement();
                this.removerMob.setDeltaMovement(var4.x, 0.3, var4.z);
                if (!var0.isClientSide) {
                    var5 = 0.08;
                    ((WorldServer)var0).sendParticles(new ParticleParamItem(Particles.ITEM, new ItemStack(Items.EGG)), (double)var2.getX() + 0.5, (double)var2.getY() + 0.7, (double)var2.getZ() + 0.5, 3, ((double)var3.nextFloat() - 0.5) * 0.08, ((double)var3.nextFloat() - 0.5) * 0.08, ((double)var3.nextFloat() - 0.5) * 0.08, 0.15f);
                }
            }
            if (this.ticksSinceReachedGoal % 2 == 0) {
                var4 = this.removerMob.getDeltaMovement();
                this.removerMob.setDeltaMovement(var4.x, -0.3, var4.z);
                if (this.ticksSinceReachedGoal % 6 == 0) {
                    this.playDestroyProgressSound(var0, this.blockPos);
                }
            }
            if (this.ticksSinceReachedGoal > 60) {
                var0.removeBlock(var2, false);
                if (!var0.isClientSide) {
                    for (int var42 = 0; var42 < 20; ++var42) {
                        var5 = var3.nextGaussian() * 0.02;
                        double var7 = var3.nextGaussian() * 0.02;
                        double var9 = var3.nextGaussian() * 0.02;
                        ((WorldServer)var0).sendParticles(Particles.POOF, (double)var2.getX() + 0.5, var2.getY(), (double)var2.getZ() + 0.5, 1, var5, var7, var9, 0.15f);
                    }
                    this.playBreakSound(var0, var2);
                }
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    @Nullable
    private BlockPosition getPosWithBlock(BlockPosition var0, IBlockAccess var1) {
        BlockPosition[] var2;
        if (var1.getBlockState(var0).is(this.blockToRemove)) {
            return var0;
        }
        for (BlockPosition var6 : var2 = new BlockPosition[]{var0.below(), var0.west(), var0.east(), var0.north(), var0.south(), var0.below().below()}) {
            if (!var1.getBlockState(var6).is(this.blockToRemove)) continue;
            return var6;
        }
        return null;
    }

    @Override
    protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
        IChunkAccess var2 = var0.getChunk(SectionPosition.blockToSectionCoord(var1.getX()), SectionPosition.blockToSectionCoord(var1.getZ()), ChunkStatus.FULL, false);
        if (var2 != null) {
            return var2.getBlockState(var1).is(this.blockToRemove) && var2.getBlockState(var1.above()).isAir() && var2.getBlockState(var1.above(2)).isAir();
        }
        return false;
    }
}

