/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.pathfinder.PathEntity;

public class PathfinderGoalMeleeAttack
extends PathfinderGoal {
    protected final EntityCreature mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private PathEntity path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;

    public PathfinderGoalMeleeAttack(EntityCreature var0, double var1, boolean var3) {
        this.mob = var0;
        this.speedModifier = var1;
        this.followingTargetEvenIfNotSeen = var3;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        long var0 = this.mob.level().getGameTime();
        if (var0 - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = var0;
        EntityLiving var2 = this.mob.getTarget();
        if (var2 == null) {
            return false;
        }
        if (!var2.isAlive()) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath(var2, 0);
        if (this.path != null) {
            return true;
        }
        return this.mob.isWithinMeleeAttackRange(var2);
    }

    @Override
    public boolean canContinueToUse() {
        EntityLiving var0 = this.mob.getTarget();
        if (var0 == null) {
            return false;
        }
        if (!var0.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.getNavigation().isDone();
        }
        if (!this.mob.isWithinRestriction(var0.blockPosition())) {
            return false;
        }
        return !(var0 instanceof EntityHuman) || !var0.isSpectator() && !((EntityHuman)var0).isCreative();
    }

    @Override
    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    @Override
    public void stop() {
        EntityLiving var0 = this.mob.getTarget();
        if (!IEntitySelector.NO_CREATIVE_OR_SPECTATOR.test(var0)) {
            this.mob.setTarget(null);
        }
        this.mob.setAggressive(false);
        this.mob.getNavigation().stop();
    }

    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void tick() {
        EntityLiving var0 = this.mob.getTarget();
        if (var0 == null) {
            return;
        }
        this.mob.getLookControl().setLookAt(var0, 30.0f, 30.0f);
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight(var0)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || var0.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
            this.pathedTargetX = var0.getX();
            this.pathedTargetY = var0.getY();
            this.pathedTargetZ = var0.getZ();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
            double var1 = this.mob.distanceToSqr(var0);
            if (var1 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (var1 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.getNavigation().moveTo(var0, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(var0);
    }

    protected void checkAndPerformAttack(EntityLiving var0) {
        if (this.canPerformAttack(var0)) {
            this.resetAttackCooldown();
            this.mob.swing(EnumHand.MAIN_HAND);
            this.mob.doHurtTarget(PathfinderGoalMeleeAttack.getServerLevel(this.mob), var0);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(EntityLiving var0) {
        return this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(var0) && this.mob.getSensing().hasLineOfSight(var0);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.adjustedTickDelay(20);
    }
}

