/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.level.pathfinder.PathType;

public class PathfinderGoalFollowEntity
extends PathfinderGoal {
    private final EntityInsentient mob;
    private final Predicate<EntityInsentient> followPredicate;
    @Nullable
    private EntityInsentient followingMob;
    private final double speedModifier;
    private final NavigationAbstract navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;
    private final float areaSize;

    public PathfinderGoalFollowEntity(EntityInsentient var0, double var12, float var3, float var4) {
        this.mob = var0;
        this.followPredicate = var1 -> var1 != null && var0.getClass() != var1.getClass();
        this.speedModifier = var12;
        this.navigation = var0.getNavigation();
        this.stopDistance = var3;
        this.areaSize = var4;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        if (!(var0.getNavigation() instanceof Navigation) && !(var0.getNavigation() instanceof NavigationFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    @Override
    public boolean canUse() {
        List<EntityInsentient> var0 = this.mob.level().getEntitiesOfClass(EntityInsentient.class, this.mob.getBoundingBox().inflate(this.areaSize), this.followPredicate);
        if (!var0.isEmpty()) {
            for (EntityInsentient var2 : var0) {
                if (var2.isInvisible()) continue;
                this.followingMob = var2;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canContinueToUse() {
        return this.followingMob != null && !this.navigation.isDone() && this.mob.distanceToSqr(this.followingMob) > (double)(this.stopDistance * this.stopDistance);
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public void stop() {
        this.followingMob = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    @Override
    public void tick() {
        double var4;
        double var2;
        if (this.followingMob == null || this.mob.isLeashed()) {
            return;
        }
        this.mob.getLookControl().setLookAt(this.followingMob, 10.0f, this.mob.getMaxHeadXRot());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        double var0 = this.mob.getX() - this.followingMob.getX();
        double var6 = var0 * var0 + (var2 = this.mob.getY() - this.followingMob.getY()) * var2 + (var4 = this.mob.getZ() - this.followingMob.getZ()) * var4;
        if (var6 <= (double)(this.stopDistance * this.stopDistance)) {
            this.navigation.stop();
            ControllerLook var8 = this.followingMob.getLookControl();
            if (var6 <= (double)this.stopDistance || var8.getWantedX() == this.mob.getX() && var8.getWantedY() == this.mob.getY() && var8.getWantedZ() == this.mob.getZ()) {
                double var9 = this.followingMob.getX() - this.mob.getX();
                double var11 = this.followingMob.getZ() - this.mob.getZ();
                this.navigation.moveTo(this.mob.getX() - var9, this.mob.getY(), this.mob.getZ() - var11, this.speedModifier);
            }
            return;
        }
        this.navigation.moveTo(this.followingMob, this.speedModifier);
    }
}

